package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait Owner {
  def unwrap: software.amazon.awssdk.services.config.model.Owner
}
object Owner {
  def wrap(
      value: software.amazon.awssdk.services.config.model.Owner
  ): zio.aws.config.model.Owner = value match {
    case software.amazon.awssdk.services.config.model.Owner.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.Owner.CUSTOM_LAMBDA =>
      val r = CUSTOM_LAMBDA
      r
    case software.amazon.awssdk.services.config.model.Owner.AWS =>
      val r = AWS
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.Owner {
    override def unwrap: software.amazon.awssdk.services.config.model.Owner =
      software.amazon.awssdk.services.config.model.Owner.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOM_LAMBDA extends zio.aws.config.model.Owner {
    override def unwrap: software.amazon.awssdk.services.config.model.Owner =
      software.amazon.awssdk.services.config.model.Owner.CUSTOM_LAMBDA
  }
  case object AWS extends zio.aws.config.model.Owner {
    override def unwrap: software.amazon.awssdk.services.config.model.Owner =
      software.amazon.awssdk.services.config.model.Owner.AWS
  }
}
