package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetResourceConfigHistoryResponse(
    configurationItems: Option[
      Iterable[zio.aws.config.model.ConfigurationItem]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse = {
    import GetResourceConfigHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse
      .builder()
      .optionallyWith(
        configurationItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly =
    zio.aws.config.model.GetResourceConfigHistoryResponse.wrap(buildAwsValue())
}
object GetResourceConfigHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetResourceConfigHistoryResponse =
      zio.aws.config.model.GetResourceConfigHistoryResponse(
        configurationItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configurationItems
        : Option[List[zio.aws.config.model.ConfigurationItem.ReadOnly]]
    def nextToken: Option[NextToken]
    def getConfigurationItems: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField("configurationItems", configurationItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse
  ) extends zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly {
    override val configurationItems
        : Option[List[zio.aws.config.model.ConfigurationItem.ReadOnly]] = scala
      .Option(impl.configurationItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConfigurationItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse
  ): zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
