package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  NextToken,
  PageSizeLimit,
  ConformancePackName
}
import scala.jdk.CollectionConverters.*
final case class GetConformancePackComplianceSummaryRequest(
    conformancePackNames: Iterable[ConformancePackName],
    limit: Option[PageSizeLimit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest = {
    import GetConformancePackComplianceSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest
      .builder()
      .conformancePackNames(conformancePackNames.map { item =>
        ConformancePackName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(limit.map(value => PageSizeLimit.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetConformancePackComplianceSummaryRequest.ReadOnly =
    zio.aws.config.model.GetConformancePackComplianceSummaryRequest
      .wrap(buildAwsValue())
}
object GetConformancePackComplianceSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetConformancePackComplianceSummaryRequest =
      zio.aws.config.model.GetConformancePackComplianceSummaryRequest(
        conformancePackNames,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def conformancePackNames: List[ConformancePackName]
    def limit: Option[PageSizeLimit]
    def nextToken: Option[NextToken]
    def getConformancePackNames: ZIO[Any, Nothing, List[ConformancePackName]] =
      ZIO.succeed(conformancePackNames)
    def getLimit: ZIO[Any, AwsError, PageSizeLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest
  ) extends zio.aws.config.model.GetConformancePackComplianceSummaryRequest.ReadOnly {
    override val conformancePackNames: List[ConformancePackName] = impl
      .conformancePackNames()
      .asScala
      .map { item =>
        zio.aws.config.model.primitives.ConformancePackName(item)
      }
      .toList
    override val limit: Option[PageSizeLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.PageSizeLimit(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest
  ): zio.aws.config.model.GetConformancePackComplianceSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
