package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  NextToken,
  GetConformancePackComplianceDetailsLimit,
  ConformancePackName
}
import scala.jdk.CollectionConverters.*
final case class GetConformancePackComplianceDetailsRequest(
    conformancePackName: ConformancePackName,
    filters: Option[zio.aws.config.model.ConformancePackEvaluationFilters] =
      None,
    limit: Option[GetConformancePackComplianceDetailsLimit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest = {
    import GetConformancePackComplianceDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        limit.map(value =>
          GetConformancePackComplianceDetailsLimit.unwrap(value): Integer
        )
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetConformancePackComplianceDetailsRequest.ReadOnly =
    zio.aws.config.model.GetConformancePackComplianceDetailsRequest
      .wrap(buildAwsValue())
}
object GetConformancePackComplianceDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetConformancePackComplianceDetailsRequest =
      zio.aws.config.model.GetConformancePackComplianceDetailsRequest(
        conformancePackName,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def conformancePackName: ConformancePackName
    def filters
        : Option[zio.aws.config.model.ConformancePackEvaluationFilters.ReadOnly]
    def limit: Option[GetConformancePackComplianceDetailsLimit]
    def nextToken: Option[NextToken]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackEvaluationFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, GetConformancePackComplianceDetailsLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest
  ) extends zio.aws.config.model.GetConformancePackComplianceDetailsRequest.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val filters: Option[
      zio.aws.config.model.ConformancePackEvaluationFilters.ReadOnly
    ] = scala
      .Option(impl.filters())
      .map(value =>
        zio.aws.config.model.ConformancePackEvaluationFilters.wrap(value)
      )
    override val limit: Option[GetConformancePackComplianceDetailsLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.config.model.primitives
          .GetConformancePackComplianceDetailsLimit(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest
  ): zio.aws.config.model.GetConformancePackComplianceDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
