package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExecutionControls(
    ssmControls: Option[zio.aws.config.model.SsmControls] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ExecutionControls = {
    import ExecutionControls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ExecutionControls
      .builder()
      .optionallyWith(ssmControls.map(value => value.buildAwsValue()))(
        _.ssmControls
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ExecutionControls.ReadOnly =
    zio.aws.config.model.ExecutionControls.wrap(buildAwsValue())
}
object ExecutionControls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ExecutionControls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ExecutionControls =
      zio.aws.config.model
        .ExecutionControls(ssmControls.map(value => value.asEditable))
    def ssmControls: Option[zio.aws.config.model.SsmControls.ReadOnly]
    def getSsmControls
        : ZIO[Any, AwsError, zio.aws.config.model.SsmControls.ReadOnly] =
      AwsError.unwrapOptionField("ssmControls", ssmControls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ExecutionControls
  ) extends zio.aws.config.model.ExecutionControls.ReadOnly {
    override val ssmControls
        : Option[zio.aws.config.model.SsmControls.ReadOnly] = scala
      .Option(impl.ssmControls())
      .map(value => zio.aws.config.model.SsmControls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ExecutionControls
  ): zio.aws.config.model.ExecutionControls.ReadOnly = new Wrapper(impl)
}
