package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeliveryChannelStatus(
    name: Option[String] = None,
    configSnapshotDeliveryInfo: Option[
      zio.aws.config.model.ConfigExportDeliveryInfo
    ] = None,
    configHistoryDeliveryInfo: Option[
      zio.aws.config.model.ConfigExportDeliveryInfo
    ] = None,
    configStreamDeliveryInfo: Option[
      zio.aws.config.model.ConfigStreamDeliveryInfo
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeliveryChannelStatus = {
    import DeliveryChannelStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeliveryChannelStatus
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        configSnapshotDeliveryInfo.map(value => value.buildAwsValue())
      )(_.configSnapshotDeliveryInfo)
      .optionallyWith(
        configHistoryDeliveryInfo.map(value => value.buildAwsValue())
      )(_.configHistoryDeliveryInfo)
      .optionallyWith(
        configStreamDeliveryInfo.map(value => value.buildAwsValue())
      )(_.configStreamDeliveryInfo)
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeliveryChannelStatus.ReadOnly =
    zio.aws.config.model.DeliveryChannelStatus.wrap(buildAwsValue())
}
object DeliveryChannelStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeliveryChannelStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeliveryChannelStatus =
      zio.aws.config.model.DeliveryChannelStatus(
        name.map(value => value),
        configSnapshotDeliveryInfo.map(value => value.asEditable),
        configHistoryDeliveryInfo.map(value => value.asEditable),
        configStreamDeliveryInfo.map(value => value.asEditable)
      )
    def name: Option[String]
    def configSnapshotDeliveryInfo
        : Option[zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly]
    def configHistoryDeliveryInfo
        : Option[zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly]
    def configStreamDeliveryInfo
        : Option[zio.aws.config.model.ConfigStreamDeliveryInfo.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getConfigSnapshotDeliveryInfo: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configSnapshotDeliveryInfo",
      configSnapshotDeliveryInfo
    )
    def getConfigHistoryDeliveryInfo: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configHistoryDeliveryInfo",
      configHistoryDeliveryInfo
    )
    def getConfigStreamDeliveryInfo: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigStreamDeliveryInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configStreamDeliveryInfo",
      configStreamDeliveryInfo
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeliveryChannelStatus
  ) extends zio.aws.config.model.DeliveryChannelStatus.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val configSnapshotDeliveryInfo
        : Option[zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly] = scala
      .Option(impl.configSnapshotDeliveryInfo())
      .map(value => zio.aws.config.model.ConfigExportDeliveryInfo.wrap(value))
    override val configHistoryDeliveryInfo
        : Option[zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly] = scala
      .Option(impl.configHistoryDeliveryInfo())
      .map(value => zio.aws.config.model.ConfigExportDeliveryInfo.wrap(value))
    override val configStreamDeliveryInfo
        : Option[zio.aws.config.model.ConfigStreamDeliveryInfo.ReadOnly] = scala
      .Option(impl.configStreamDeliveryInfo())
      .map(value => zio.aws.config.model.ConfigStreamDeliveryInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeliveryChannelStatus
  ): zio.aws.config.model.DeliveryChannelStatus.ReadOnly = new Wrapper(impl)
}
