package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  DeliveryS3KeyPrefix,
  ConformancePackName,
  DeliveryS3Bucket,
  Date,
  StringWithCharLimit256,
  ConformancePackArn,
  ConformancePackId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ConformancePackDetail(
    conformancePackName: ConformancePackName,
    conformancePackArn: ConformancePackArn,
    conformancePackId: ConformancePackId,
    deliveryS3Bucket: Option[DeliveryS3Bucket] = None,
    deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix] = None,
    conformancePackInputParameters: Option[
      Iterable[zio.aws.config.model.ConformancePackInputParameter]
    ] = None,
    lastUpdateRequestedTime: Option[Date] = None,
    createdBy: Option[StringWithCharLimit256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackDetail = {
    import ConformancePackDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackDetail
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .conformancePackArn(
        ConformancePackArn.unwrap(conformancePackArn): java.lang.String
      )
      .conformancePackId(
        ConformancePackId.unwrap(conformancePackId): java.lang.String
      )
      .optionallyWith(
        deliveryS3Bucket.map(value =>
          DeliveryS3Bucket.unwrap(value): java.lang.String
        )
      )(_.deliveryS3Bucket)
      .optionallyWith(
        deliveryS3KeyPrefix.map(value =>
          DeliveryS3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.deliveryS3KeyPrefix)
      .optionallyWith(
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackInputParameters)
      .optionallyWith(
        lastUpdateRequestedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdateRequestedTime)
      .optionallyWith(
        createdBy.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConformancePackDetail.ReadOnly =
    zio.aws.config.model.ConformancePackDetail.wrap(buildAwsValue())
}
object ConformancePackDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackDetail =
      zio.aws.config.model.ConformancePackDetail(
        conformancePackName,
        conformancePackArn,
        conformancePackId,
        deliveryS3Bucket.map(value => value),
        deliveryS3KeyPrefix.map(value => value),
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdateRequestedTime.map(value => value),
        createdBy.map(value => value)
      )
    def conformancePackName: ConformancePackName
    def conformancePackArn: ConformancePackArn
    def conformancePackId: ConformancePackId
    def deliveryS3Bucket: Option[DeliveryS3Bucket]
    def deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix]
    def conformancePackInputParameters: Option[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ]
    def lastUpdateRequestedTime: Option[Date]
    def createdBy: Option[StringWithCharLimit256]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getConformancePackArn: ZIO[Any, Nothing, ConformancePackArn] =
      ZIO.succeed(conformancePackArn)
    def getConformancePackId: ZIO[Any, Nothing, ConformancePackId] =
      ZIO.succeed(conformancePackId)
    def getDeliveryS3Bucket: ZIO[Any, AwsError, DeliveryS3Bucket] =
      AwsError.unwrapOptionField("deliveryS3Bucket", deliveryS3Bucket)
    def getDeliveryS3KeyPrefix: ZIO[Any, AwsError, DeliveryS3KeyPrefix] =
      AwsError.unwrapOptionField("deliveryS3KeyPrefix", deliveryS3KeyPrefix)
    def getConformancePackInputParameters: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackInputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackInputParameters",
      conformancePackInputParameters
    )
    def getLastUpdateRequestedTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastUpdateRequestedTime", lastUpdateRequestedTime)
    def getCreatedBy: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackDetail
  ) extends zio.aws.config.model.ConformancePackDetail.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val conformancePackArn: ConformancePackArn =
      zio.aws.config.model.primitives
        .ConformancePackArn(impl.conformancePackArn())
    override val conformancePackId: ConformancePackId =
      zio.aws.config.model.primitives
        .ConformancePackId(impl.conformancePackId())
    override val deliveryS3Bucket: Option[DeliveryS3Bucket] = scala
      .Option(impl.deliveryS3Bucket())
      .map(value => zio.aws.config.model.primitives.DeliveryS3Bucket(value))
    override val deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix] = scala
      .Option(impl.deliveryS3KeyPrefix())
      .map(value => zio.aws.config.model.primitives.DeliveryS3KeyPrefix(value))
    override val conformancePackInputParameters: Option[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ] = scala
      .Option(impl.conformancePackInputParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConformancePackInputParameter.wrap(item)
        }.toList
      )
    override val lastUpdateRequestedTime: Option[Date] = scala
      .Option(impl.lastUpdateRequestedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val createdBy: Option[StringWithCharLimit256] = scala
      .Option(impl.createdBy())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackDetail
  ): zio.aws.config.model.ConformancePackDetail.ReadOnly = new Wrapper(impl)
}
