package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Date
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ComplianceSummary(
    compliantResourceCount: Option[
      zio.aws.config.model.ComplianceContributorCount
    ] = None,
    nonCompliantResourceCount: Option[
      zio.aws.config.model.ComplianceContributorCount
    ] = None,
    complianceSummaryTimestamp: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceSummary = {
    import ComplianceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceSummary
      .builder()
      .optionallyWith(
        compliantResourceCount.map(value => value.buildAwsValue())
      )(_.compliantResourceCount)
      .optionallyWith(
        nonCompliantResourceCount.map(value => value.buildAwsValue())
      )(_.nonCompliantResourceCount)
      .optionallyWith(
        complianceSummaryTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.complianceSummaryTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ComplianceSummary.ReadOnly =
    zio.aws.config.model.ComplianceSummary.wrap(buildAwsValue())
}
object ComplianceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceSummary =
      zio.aws.config.model.ComplianceSummary(
        compliantResourceCount.map(value => value.asEditable),
        nonCompliantResourceCount.map(value => value.asEditable),
        complianceSummaryTimestamp.map(value => value)
      )
    def compliantResourceCount
        : Option[zio.aws.config.model.ComplianceContributorCount.ReadOnly]
    def nonCompliantResourceCount
        : Option[zio.aws.config.model.ComplianceContributorCount.ReadOnly]
    def complianceSummaryTimestamp: Option[Date]
    def getCompliantResourceCount: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ComplianceContributorCount.ReadOnly
    ] = AwsError.unwrapOptionField(
      "compliantResourceCount",
      compliantResourceCount
    )
    def getNonCompliantResourceCount: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ComplianceContributorCount.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nonCompliantResourceCount",
      nonCompliantResourceCount
    )
    def getComplianceSummaryTimestamp: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "complianceSummaryTimestamp",
        complianceSummaryTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummary
  ) extends zio.aws.config.model.ComplianceSummary.ReadOnly {
    override val compliantResourceCount
        : Option[zio.aws.config.model.ComplianceContributorCount.ReadOnly] =
      scala
        .Option(impl.compliantResourceCount())
        .map(value =>
          zio.aws.config.model.ComplianceContributorCount.wrap(value)
        )
    override val nonCompliantResourceCount
        : Option[zio.aws.config.model.ComplianceContributorCount.ReadOnly] =
      scala
        .Option(impl.nonCompliantResourceCount())
        .map(value =>
          zio.aws.config.model.ComplianceContributorCount.wrap(value)
        )
    override val complianceSummaryTimestamp: Option[Date] = scala
      .Option(impl.complianceSummaryTimestamp())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummary
  ): zio.aws.config.model.ComplianceSummary.ReadOnly = new Wrapper(impl)
}
