package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{BaseResourceId, StringWithCharLimit256}
import scala.jdk.CollectionConverters.*
final case class ComplianceByResource(
    resourceType: Option[StringWithCharLimit256] = None,
    resourceId: Option[BaseResourceId] = None,
    compliance: Option[zio.aws.config.model.Compliance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceByResource = {
    import ComplianceByResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceByResource
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => BaseResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(compliance.map(value => value.buildAwsValue()))(
        _.compliance
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ComplianceByResource.ReadOnly =
    zio.aws.config.model.ComplianceByResource.wrap(buildAwsValue())
}
object ComplianceByResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceByResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceByResource =
      zio.aws.config.model.ComplianceByResource(
        resourceType.map(value => value),
        resourceId.map(value => value),
        compliance.map(value => value.asEditable)
      )
    def resourceType: Option[StringWithCharLimit256]
    def resourceId: Option[BaseResourceId]
    def compliance: Option[zio.aws.config.model.Compliance.ReadOnly]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getCompliance
        : ZIO[Any, AwsError, zio.aws.config.model.Compliance.ReadOnly] =
      AwsError.unwrapOptionField("compliance", compliance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceByResource
  ) extends zio.aws.config.model.ComplianceByResource.ReadOnly {
    override val resourceType: Option[StringWithCharLimit256] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val resourceId: Option[BaseResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
    override val compliance: Option[zio.aws.config.model.Compliance.ReadOnly] =
      scala
        .Option(impl.compliance())
        .map(value => zio.aws.config.model.Compliance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceByResource
  ): zio.aws.config.model.ComplianceByResource.ReadOnly = new Wrapper(impl)
}
