package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit64
import scala.jdk.CollectionConverters.*
final case class ComplianceByConfigRule(
    configRuleName: Option[StringWithCharLimit64] = None,
    compliance: Option[zio.aws.config.model.Compliance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceByConfigRule = {
    import ComplianceByConfigRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceByConfigRule
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          StringWithCharLimit64.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(compliance.map(value => value.buildAwsValue()))(
        _.compliance
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ComplianceByConfigRule.ReadOnly =
    zio.aws.config.model.ComplianceByConfigRule.wrap(buildAwsValue())
}
object ComplianceByConfigRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceByConfigRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceByConfigRule =
      zio.aws.config.model.ComplianceByConfigRule(
        configRuleName.map(value => value),
        compliance.map(value => value.asEditable)
      )
    def configRuleName: Option[StringWithCharLimit64]
    def compliance: Option[zio.aws.config.model.Compliance.ReadOnly]
    def getConfigRuleName: ZIO[Any, AwsError, StringWithCharLimit64] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getCompliance
        : ZIO[Any, AwsError, zio.aws.config.model.Compliance.ReadOnly] =
      AwsError.unwrapOptionField("compliance", compliance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceByConfigRule
  ) extends zio.aws.config.model.ComplianceByConfigRule.ReadOnly {
    override val configRuleName: Option[StringWithCharLimit64] = scala
      .Option(impl.configRuleName())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit64(value)
      )
    override val compliance: Option[zio.aws.config.model.Compliance.ReadOnly] =
      scala
        .Option(impl.compliance())
        .map(value => zio.aws.config.model.Compliance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceByConfigRule
  ): zio.aws.config.model.ComplianceByConfigRule.ReadOnly = new Wrapper(impl)
}
