package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId, ConfigRuleName}
import scala.jdk.CollectionConverters.*
final case class AggregateComplianceByConfigRule(
    configRuleName: Option[ConfigRuleName] = None,
    compliance: Option[zio.aws.config.model.Compliance] = None,
    accountId: Option[AccountId] = None,
    awsRegion: Option[AwsRegion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRule = {
    import AggregateComplianceByConfigRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRule
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(compliance.map(value => value.buildAwsValue()))(
        _.compliance
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly =
    zio.aws.config.model.AggregateComplianceByConfigRule.wrap(buildAwsValue())
}
object AggregateComplianceByConfigRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregateComplianceByConfigRule =
      zio.aws.config.model.AggregateComplianceByConfigRule(
        configRuleName.map(value => value),
        compliance.map(value => value.asEditable),
        accountId.map(value => value),
        awsRegion.map(value => value)
      )
    def configRuleName: Option[ConfigRuleName]
    def compliance: Option[zio.aws.config.model.Compliance.ReadOnly]
    def accountId: Option[AccountId]
    def awsRegion: Option[AwsRegion]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getCompliance
        : ZIO[Any, AwsError, zio.aws.config.model.Compliance.ReadOnly] =
      AwsError.unwrapOptionField("compliance", compliance)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRule
  ) extends zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly {
    override val configRuleName: Option[ConfigRuleName] = scala
      .Option(impl.configRuleName())
      .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val compliance: Option[zio.aws.config.model.Compliance.ReadOnly] =
      scala
        .Option(impl.compliance())
        .map(value => zio.aws.config.model.Compliance.wrap(value))
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val awsRegion: Option[AwsRegion] = scala
      .Option(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRule
  ): zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly =
    new Wrapper(impl)
}
