package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  ConfigurationAggregatorName,
  Expression
}
import scala.jdk.CollectionConverters.*
final case class SelectAggregateResourceConfigRequest(
    expression: Expression,
    configurationAggregatorName: ConfigurationAggregatorName,
    limit: Option[Limit] = None,
    maxResults: Option[Limit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest = {
    import SelectAggregateResourceConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest
      .builder()
      .expression(Expression.unwrap(expression): java.lang.String)
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.SelectAggregateResourceConfigRequest.ReadOnly =
    zio.aws.config.model.SelectAggregateResourceConfigRequest
      .wrap(buildAwsValue())
}
object SelectAggregateResourceConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.SelectAggregateResourceConfigRequest =
      zio.aws.config.model.SelectAggregateResourceConfigRequest(
        expression,
        configurationAggregatorName,
        limit.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def expression: Expression
    def configurationAggregatorName: ConfigurationAggregatorName
    def limit: Option[Limit]
    def maxResults: Option[Limit]
    def nextToken: Option[NextToken]
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest
  ) extends zio.aws.config.model.SelectAggregateResourceConfigRequest.ReadOnly {
    override val expression: Expression =
      zio.aws.config.model.primitives.Expression(impl.expression())
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val maxResults: Option[Limit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest
  ): zio.aws.config.model.SelectAggregateResourceConfigRequest.ReadOnly =
    new Wrapper(impl)
}
