package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.config.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ResourceType
  ): zio.aws.config.model.ResourceType = value match {
    case software.amazon.awssdk.services.config.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_CUSTOMER_GATEWAY =>
      val r = `AWS::EC2::CustomerGateway`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_EIP =>
      val r = `AWS::EC2::EIP`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_HOST =>
      val r = `AWS::EC2::Host`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_INSTANCE =>
      val r = `AWS::EC2::Instance`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_INTERNET_GATEWAY =>
      val r = `AWS::EC2::InternetGateway`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_NETWORK_ACL =>
      val r = `AWS::EC2::NetworkAcl`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_NETWORK_INTERFACE =>
      val r = `AWS::EC2::NetworkInterface`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_ROUTE_TABLE =>
      val r = `AWS::EC2::RouteTable`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_SECURITY_GROUP =>
      val r = `AWS::EC2::SecurityGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_SUBNET =>
      val r = `AWS::EC2::Subnet`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_TRAIL_TRAIL =>
      val r = `AWS::CloudTrail::Trail`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VOLUME =>
      val r = `AWS::EC2::Volume`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC =>
      val r = `AWS::EC2::VPC`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPN_CONNECTION =>
      val r = `AWS::EC2::VPNConnection`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPN_GATEWAY =>
      val r = `AWS::EC2::VPNGateway`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_REGISTERED_HA_INSTANCE =>
      val r = `AWS::EC2::RegisteredHAInstance`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_NAT_GATEWAY =>
      val r = `AWS::EC2::NatGateway`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_EGRESS_ONLY_INTERNET_GATEWAY =>
      val r = `AWS::EC2::EgressOnlyInternetGateway`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC_ENDPOINT =>
      val r = `AWS::EC2::VPCEndpoint`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC_ENDPOINT_SERVICE =>
      val r = `AWS::EC2::VPCEndpointService`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_FLOW_LOG =>
      val r = `AWS::EC2::FlowLog`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC_PEERING_CONNECTION =>
      val r = `AWS::EC2::VPCPeeringConnection`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTICSEARCH_DOMAIN =>
      val r = `AWS::Elasticsearch::Domain`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_GROUP =>
      val r = `AWS::IAM::Group`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_POLICY =>
      val r = `AWS::IAM::Policy`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_ROLE =>
      val r = `AWS::IAM::Role`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_USER =>
      val r = `AWS::IAM::User`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER =>
      val r = `AWS::ElasticLoadBalancingV2::LoadBalancer`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ACM_CERTIFICATE =>
      val r = `AWS::ACM::Certificate`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_INSTANCE =>
      val r = `AWS::RDS::DBInstance`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_SUBNET_GROUP =>
      val r = `AWS::RDS::DBSubnetGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_SECURITY_GROUP =>
      val r = `AWS::RDS::DBSecurityGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_SNAPSHOT =>
      val r = `AWS::RDS::DBSnapshot`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_CLUSTER =>
      val r = `AWS::RDS::DBCluster`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_CLUSTER_SNAPSHOT =>
      val r = `AWS::RDS::DBClusterSnapshot`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_EVENT_SUBSCRIPTION =>
      val r = `AWS::RDS::EventSubscription`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_S3_BUCKET =>
      val r = `AWS::S3::Bucket`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_S3_ACCOUNT_PUBLIC_ACCESS_BLOCK =>
      val r = `AWS::S3::AccountPublicAccessBlock`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER =>
      val r = `AWS::Redshift::Cluster`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_SNAPSHOT =>
      val r = `AWS::Redshift::ClusterSnapshot`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_PARAMETER_GROUP =>
      val r = `AWS::Redshift::ClusterParameterGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_SECURITY_GROUP =>
      val r = `AWS::Redshift::ClusterSecurityGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_SUBNET_GROUP =>
      val r = `AWS::Redshift::ClusterSubnetGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_EVENT_SUBSCRIPTION =>
      val r = `AWS::Redshift::EventSubscription`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_MANAGED_INSTANCE_INVENTORY =>
      val r = `AWS::SSM::ManagedInstanceInventory`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_WATCH_ALARM =>
      val r = `AWS::CloudWatch::Alarm`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_FORMATION_STACK =>
      val r = `AWS::CloudFormation::Stack`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_LOAD_BALANCING_LOAD_BALANCER =>
      val r = `AWS::ElasticLoadBalancing::LoadBalancer`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_AUTO_SCALING_GROUP =>
      val r = `AWS::AutoScaling::AutoScalingGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_LAUNCH_CONFIGURATION =>
      val r = `AWS::AutoScaling::LaunchConfiguration`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_SCALING_POLICY =>
      val r = `AWS::AutoScaling::ScalingPolicy`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_SCHEDULED_ACTION =>
      val r = `AWS::AutoScaling::ScheduledAction`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_DYNAMO_DB_TABLE =>
      val r = `AWS::DynamoDB::Table`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CODE_BUILD_PROJECT =>
      val r = `AWS::CodeBuild::Project`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_RATE_BASED_RULE =>
      val r = `AWS::WAF::RateBasedRule`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_RULE =>
      val r = `AWS::WAF::Rule`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_RULE_GROUP =>
      val r = `AWS::WAF::RuleGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_WEB_ACL =>
      val r = `AWS::WAF::WebACL`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_RATE_BASED_RULE =>
      val r = `AWS::WAFRegional::RateBasedRule`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_RULE =>
      val r = `AWS::WAFRegional::Rule`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_RULE_GROUP =>
      val r = `AWS::WAFRegional::RuleGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_WEB_ACL =>
      val r = `AWS::WAFRegional::WebACL`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_FRONT_DISTRIBUTION =>
      val r = `AWS::CloudFront::Distribution`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_FRONT_STREAMING_DISTRIBUTION =>
      val r = `AWS::CloudFront::StreamingDistribution`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_LAMBDA_FUNCTION =>
      val r = `AWS::Lambda::Function`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_NETWORK_FIREWALL_FIREWALL =>
      val r = `AWS::NetworkFirewall::Firewall`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_NETWORK_FIREWALL_FIREWALL_POLICY =>
      val r = `AWS::NetworkFirewall::FirewallPolicy`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_NETWORK_FIREWALL_RULE_GROUP =>
      val r = `AWS::NetworkFirewall::RuleGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_BEANSTALK_APPLICATION =>
      val r = `AWS::ElasticBeanstalk::Application`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_BEANSTALK_APPLICATION_VERSION =>
      val r = `AWS::ElasticBeanstalk::ApplicationVersion`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_BEANSTALK_ENVIRONMENT =>
      val r = `AWS::ElasticBeanstalk::Environment`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_WEB_ACL =>
      val r = `AWS::WAFv2::WebACL`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_RULE_GROUP =>
      val r = `AWS::WAFv2::RuleGroup`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_IP_SET =>
      val r = `AWS::WAFv2::IPSet`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_REGEX_PATTERN_SET =>
      val r = `AWS::WAFv2::RegexPatternSet`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_MANAGED_RULE_SET =>
      val r = `AWS::WAFv2::ManagedRuleSet`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_X_RAY_ENCRYPTION_CONFIG =>
      val r = `AWS::XRay::EncryptionConfig`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_ASSOCIATION_COMPLIANCE =>
      val r = `AWS::SSM::AssociationCompliance`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_PATCH_COMPLIANCE =>
      val r = `AWS::SSM::PatchCompliance`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SHIELD_PROTECTION =>
      val r = `AWS::Shield::Protection`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SHIELD_REGIONAL_PROTECTION =>
      val r = `AWS::ShieldRegional::Protection`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CONFIG_CONFORMANCE_PACK_COMPLIANCE =>
      val r = `AWS::Config::ConformancePackCompliance`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CONFIG_RESOURCE_COMPLIANCE =>
      val r = `AWS::Config::ResourceCompliance`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_STAGE =>
      val r = `AWS::ApiGateway::Stage`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_REST_API =>
      val r = `AWS::ApiGateway::RestApi`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_V2_STAGE =>
      val r = `AWS::ApiGatewayV2::Stage`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_V2_API =>
      val r = `AWS::ApiGatewayV2::Api`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_CODE_PIPELINE_PIPELINE =>
      val r = `AWS::CodePipeline::Pipeline`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SERVICE_CATALOG_CLOUD_FORMATION_PROVISIONED_PRODUCT =>
      val r = `AWS::ServiceCatalog::CloudFormationProvisionedProduct`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SERVICE_CATALOG_CLOUD_FORMATION_PRODUCT =>
      val r = `AWS::ServiceCatalog::CloudFormationProduct`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SERVICE_CATALOG_PORTFOLIO =>
      val r = `AWS::ServiceCatalog::Portfolio`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SQS_QUEUE =>
      val r = `AWS::SQS::Queue`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_KMS_KEY =>
      val r = `AWS::KMS::Key`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_QLDB_LEDGER =>
      val r = `AWS::QLDB::Ledger`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SECRETS_MANAGER_SECRET =>
      val r = `AWS::SecretsManager::Secret`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SNS_TOPIC =>
      val r = `AWS::SNS::Topic`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_FILE_DATA =>
      val r = `AWS::SSM::FileData`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_BACKUP_PLAN =>
      val r = `AWS::Backup::BackupPlan`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_BACKUP_SELECTION =>
      val r = `AWS::Backup::BackupSelection`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_BACKUP_VAULT =>
      val r = `AWS::Backup::BackupVault`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_RECOVERY_POINT =>
      val r = `AWS::Backup::RecoveryPoint`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ECR_REPOSITORY =>
      val r = `AWS::ECR::Repository`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ECS_CLUSTER =>
      val r = `AWS::ECS::Cluster`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ECS_SERVICE =>
      val r = `AWS::ECS::Service`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_ECS_TASK_DEFINITION =>
      val r = `AWS::ECS::TaskDefinition`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EFS_ACCESS_POINT =>
      val r = `AWS::EFS::AccessPoint`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EFS_FILE_SYSTEM =>
      val r = `AWS::EFS::FileSystem`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_EKS_CLUSTER =>
      val r = `AWS::EKS::Cluster`
      r
    case software.amazon.awssdk.services.config.model.ResourceType.AWS_OPEN_SEARCH_DOMAIN =>
      val r = `AWS::OpenSearch::Domain`
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `AWS::EC2::CustomerGateway`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_CUSTOMER_GATEWAY
  }
  case object `AWS::EC2::EIP` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_EIP
  }
  case object `AWS::EC2::Host` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_HOST
  }
  case object `AWS::EC2::Instance` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_INSTANCE
  }
  case object `AWS::EC2::InternetGateway`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_INTERNET_GATEWAY
  }
  case object `AWS::EC2::NetworkAcl` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_NETWORK_ACL
  }
  case object `AWS::EC2::NetworkInterface`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_NETWORK_INTERFACE
  }
  case object `AWS::EC2::RouteTable` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_ROUTE_TABLE
  }
  case object `AWS::EC2::SecurityGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_SECURITY_GROUP
  }
  case object `AWS::EC2::Subnet` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_SUBNET
  }
  case object `AWS::CloudTrail::Trail`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_TRAIL_TRAIL
  }
  case object `AWS::EC2::Volume` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VOLUME
  }
  case object `AWS::EC2::VPC` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC
  }
  case object `AWS::EC2::VPNConnection`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPN_CONNECTION
  }
  case object `AWS::EC2::VPNGateway` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPN_GATEWAY
  }
  case object `AWS::EC2::RegisteredHAInstance`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_REGISTERED_HA_INSTANCE
  }
  case object `AWS::EC2::NatGateway` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_NAT_GATEWAY
  }
  case object `AWS::EC2::EgressOnlyInternetGateway`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_EGRESS_ONLY_INTERNET_GATEWAY
  }
  case object `AWS::EC2::VPCEndpoint`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC_ENDPOINT
  }
  case object `AWS::EC2::VPCEndpointService`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC_ENDPOINT_SERVICE
  }
  case object `AWS::EC2::FlowLog` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_FLOW_LOG
  }
  case object `AWS::EC2::VPCPeeringConnection`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EC2_VPC_PEERING_CONNECTION
  }
  case object `AWS::Elasticsearch::Domain`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTICSEARCH_DOMAIN
  }
  case object `AWS::IAM::Group` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_GROUP
  }
  case object `AWS::IAM::Policy` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_POLICY
  }
  case object `AWS::IAM::Role` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_ROLE
  }
  case object `AWS::IAM::User` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_IAM_USER
  }
  case object `AWS::ElasticLoadBalancingV2::LoadBalancer`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER
  }
  case object `AWS::ACM::Certificate`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ACM_CERTIFICATE
  }
  case object `AWS::RDS::DBInstance` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_INSTANCE
  }
  case object `AWS::RDS::DBSubnetGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_SUBNET_GROUP
  }
  case object `AWS::RDS::DBSecurityGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_SECURITY_GROUP
  }
  case object `AWS::RDS::DBSnapshot` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_SNAPSHOT
  }
  case object `AWS::RDS::DBCluster` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_CLUSTER
  }
  case object `AWS::RDS::DBClusterSnapshot`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_DB_CLUSTER_SNAPSHOT
  }
  case object `AWS::RDS::EventSubscription`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_RDS_EVENT_SUBSCRIPTION
  }
  case object `AWS::S3::Bucket` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_S3_BUCKET
  }
  case object `AWS::S3::AccountPublicAccessBlock`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_S3_ACCOUNT_PUBLIC_ACCESS_BLOCK
  }
  case object `AWS::Redshift::Cluster`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER
  }
  case object `AWS::Redshift::ClusterSnapshot`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_SNAPSHOT
  }
  case object `AWS::Redshift::ClusterParameterGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_PARAMETER_GROUP
  }
  case object `AWS::Redshift::ClusterSecurityGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_SECURITY_GROUP
  }
  case object `AWS::Redshift::ClusterSubnetGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_CLUSTER_SUBNET_GROUP
  }
  case object `AWS::Redshift::EventSubscription`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_REDSHIFT_EVENT_SUBSCRIPTION
  }
  case object `AWS::SSM::ManagedInstanceInventory`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_MANAGED_INSTANCE_INVENTORY
  }
  case object `AWS::CloudWatch::Alarm`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_WATCH_ALARM
  }
  case object `AWS::CloudFormation::Stack`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_FORMATION_STACK
  }
  case object `AWS::ElasticLoadBalancing::LoadBalancer`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_LOAD_BALANCING_LOAD_BALANCER
  }
  case object `AWS::AutoScaling::AutoScalingGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_AUTO_SCALING_GROUP
  }
  case object `AWS::AutoScaling::LaunchConfiguration`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_LAUNCH_CONFIGURATION
  }
  case object `AWS::AutoScaling::ScalingPolicy`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_SCALING_POLICY
  }
  case object `AWS::AutoScaling::ScheduledAction`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_AUTO_SCALING_SCHEDULED_ACTION
  }
  case object `AWS::DynamoDB::Table` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_DYNAMO_DB_TABLE
  }
  case object `AWS::CodeBuild::Project`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CODE_BUILD_PROJECT
  }
  case object `AWS::WAF::RateBasedRule`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_RATE_BASED_RULE
  }
  case object `AWS::WAF::Rule` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_RULE
  }
  case object `AWS::WAF::RuleGroup` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_RULE_GROUP
  }
  case object `AWS::WAF::WebACL` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_WEB_ACL
  }
  case object `AWS::WAFRegional::RateBasedRule`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_RATE_BASED_RULE
  }
  case object `AWS::WAFRegional::Rule`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_RULE
  }
  case object `AWS::WAFRegional::RuleGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_RULE_GROUP
  }
  case object `AWS::WAFRegional::WebACL`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_REGIONAL_WEB_ACL
  }
  case object `AWS::CloudFront::Distribution`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_FRONT_DISTRIBUTION
  }
  case object `AWS::CloudFront::StreamingDistribution`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CLOUD_FRONT_STREAMING_DISTRIBUTION
  }
  case object `AWS::Lambda::Function`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_LAMBDA_FUNCTION
  }
  case object `AWS::NetworkFirewall::Firewall`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_NETWORK_FIREWALL_FIREWALL
  }
  case object `AWS::NetworkFirewall::FirewallPolicy`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_NETWORK_FIREWALL_FIREWALL_POLICY
  }
  case object `AWS::NetworkFirewall::RuleGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_NETWORK_FIREWALL_RULE_GROUP
  }
  case object `AWS::ElasticBeanstalk::Application`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_BEANSTALK_APPLICATION
  }
  case object `AWS::ElasticBeanstalk::ApplicationVersion`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_BEANSTALK_APPLICATION_VERSION
  }
  case object `AWS::ElasticBeanstalk::Environment`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ELASTIC_BEANSTALK_ENVIRONMENT
  }
  case object `AWS::WAFv2::WebACL` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_WEB_ACL
  }
  case object `AWS::WAFv2::RuleGroup`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_RULE_GROUP
  }
  case object `AWS::WAFv2::IPSet` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_IP_SET
  }
  case object `AWS::WAFv2::RegexPatternSet`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_REGEX_PATTERN_SET
  }
  case object `AWS::WAFv2::ManagedRuleSet`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_WAF_V2_MANAGED_RULE_SET
  }
  case object `AWS::XRay::EncryptionConfig`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_X_RAY_ENCRYPTION_CONFIG
  }
  case object `AWS::SSM::AssociationCompliance`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_ASSOCIATION_COMPLIANCE
  }
  case object `AWS::SSM::PatchCompliance`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_PATCH_COMPLIANCE
  }
  case object `AWS::Shield::Protection`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SHIELD_PROTECTION
  }
  case object `AWS::ShieldRegional::Protection`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SHIELD_REGIONAL_PROTECTION
  }
  case object `AWS::Config::ConformancePackCompliance`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CONFIG_CONFORMANCE_PACK_COMPLIANCE
  }
  case object `AWS::Config::ResourceCompliance`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CONFIG_RESOURCE_COMPLIANCE
  }
  case object `AWS::ApiGateway::Stage`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_STAGE
  }
  case object `AWS::ApiGateway::RestApi`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_REST_API
  }
  case object `AWS::ApiGatewayV2::Stage`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_V2_STAGE
  }
  case object `AWS::ApiGatewayV2::Api`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_API_GATEWAY_V2_API
  }
  case object `AWS::CodePipeline::Pipeline`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_CODE_PIPELINE_PIPELINE
  }
  case object `AWS::ServiceCatalog::CloudFormationProvisionedProduct`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SERVICE_CATALOG_CLOUD_FORMATION_PROVISIONED_PRODUCT
  }
  case object `AWS::ServiceCatalog::CloudFormationProduct`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SERVICE_CATALOG_CLOUD_FORMATION_PRODUCT
  }
  case object `AWS::ServiceCatalog::Portfolio`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SERVICE_CATALOG_PORTFOLIO
  }
  case object `AWS::SQS::Queue` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SQS_QUEUE
  }
  case object `AWS::KMS::Key` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_KMS_KEY
  }
  case object `AWS::QLDB::Ledger` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_QLDB_LEDGER
  }
  case object `AWS::SecretsManager::Secret`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SECRETS_MANAGER_SECRET
  }
  case object `AWS::SNS::Topic` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SNS_TOPIC
  }
  case object `AWS::SSM::FileData` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_SSM_FILE_DATA
  }
  case object `AWS::Backup::BackupPlan`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_BACKUP_PLAN
  }
  case object `AWS::Backup::BackupSelection`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_BACKUP_SELECTION
  }
  case object `AWS::Backup::BackupVault`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_BACKUP_VAULT
  }
  case object `AWS::Backup::RecoveryPoint`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_BACKUP_RECOVERY_POINT
  }
  case object `AWS::ECR::Repository` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ECR_REPOSITORY
  }
  case object `AWS::ECS::Cluster` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ECS_CLUSTER
  }
  case object `AWS::ECS::Service` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ECS_SERVICE
  }
  case object `AWS::ECS::TaskDefinition`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_ECS_TASK_DEFINITION
  }
  case object `AWS::EFS::AccessPoint`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EFS_ACCESS_POINT
  }
  case object `AWS::EFS::FileSystem` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EFS_FILE_SYSTEM
  }
  case object `AWS::EKS::Cluster` extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_EKS_CLUSTER
  }
  case object `AWS::OpenSearch::Domain`
      extends zio.aws.config.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceType =
      software.amazon.awssdk.services.config.model.ResourceType.AWS_OPEN_SEARCH_DOMAIN
  }
}
