package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  Date,
  StringWithCharLimit1024,
  ConfigRuleName
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PutRemediationExceptionsRequest(
    configRuleName: ConfigRuleName,
    resourceKeys: Iterable[
      zio.aws.config.model.RemediationExceptionResourceKey
    ],
    message: Option[StringWithCharLimit1024] = None,
    expirationTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest = {
    import PutRemediationExceptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .resourceKeys(resourceKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        message.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(expirationTime.map(value => Date.unwrap(value): Instant))(
        _.expirationTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutRemediationExceptionsRequest.ReadOnly =
    zio.aws.config.model.PutRemediationExceptionsRequest.wrap(buildAwsValue())
}
object PutRemediationExceptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutRemediationExceptionsRequest =
      zio.aws.config.model.PutRemediationExceptionsRequest(
        configRuleName,
        resourceKeys.map { item =>
          item.asEditable
        },
        message.map(value => value),
        expirationTime.map(value => value)
      )
    def configRuleName: ConfigRuleName
    def resourceKeys
        : List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly]
    def message: Option[StringWithCharLimit1024]
    def expirationTime: Option[Date]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getResourceKeys: ZIO[Any, Nothing, List[
      zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly
    ]] = ZIO.succeed(resourceKeys)
    def getMessage: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("message", message)
    def getExpirationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest
  ) extends zio.aws.config.model.PutRemediationExceptionsRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val resourceKeys
        : List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly] =
      impl
        .resourceKeys()
        .asScala
        .map { item =>
          zio.aws.config.model.RemediationExceptionResourceKey.wrap(item)
        }
        .toList
    override val message: Option[StringWithCharLimit1024] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit1024(value)
      )
    override val expirationTime: Option[Date] = scala
      .Option(impl.expirationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest
  ): zio.aws.config.model.PutRemediationExceptionsRequest.ReadOnly =
    new Wrapper(impl)
}
