package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigurationAggregatorName
import scala.jdk.CollectionConverters.*
final case class PutConfigurationAggregatorRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    accountAggregationSources: Option[
      Iterable[zio.aws.config.model.AccountAggregationSource]
    ] = None,
    organizationAggregationSource: Option[
      zio.aws.config.model.OrganizationAggregationSource
    ] = None,
    tags: Option[Iterable[zio.aws.config.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest = {
    import PutConfigurationAggregatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(
        accountAggregationSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAggregationSources)
      .optionallyWith(
        organizationAggregationSource.map(value => value.buildAwsValue())
      )(_.organizationAggregationSource)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutConfigurationAggregatorRequest.ReadOnly =
    zio.aws.config.model.PutConfigurationAggregatorRequest.wrap(buildAwsValue())
}
object PutConfigurationAggregatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutConfigurationAggregatorRequest =
      zio.aws.config.model.PutConfigurationAggregatorRequest(
        configurationAggregatorName,
        accountAggregationSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        organizationAggregationSource.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def accountAggregationSources
        : Option[List[zio.aws.config.model.AccountAggregationSource.ReadOnly]]
    def organizationAggregationSource
        : Option[zio.aws.config.model.OrganizationAggregationSource.ReadOnly]
    def tags: Option[List[zio.aws.config.model.Tag.ReadOnly]]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getAccountAggregationSources: ZIO[Any, AwsError, List[
      zio.aws.config.model.AccountAggregationSource.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountAggregationSources",
      accountAggregationSources
    )
    def getOrganizationAggregationSource: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationAggregationSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationAggregationSource",
      organizationAggregationSource
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.config.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
  ) extends zio.aws.config.model.PutConfigurationAggregatorRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val accountAggregationSources
        : Option[List[zio.aws.config.model.AccountAggregationSource.ReadOnly]] =
      scala
        .Option(impl.accountAggregationSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.AccountAggregationSource.wrap(item)
          }.toList
        )
    override val organizationAggregationSource
        : Option[zio.aws.config.model.OrganizationAggregationSource.ReadOnly] =
      scala
        .Option(impl.organizationAggregationSource())
        .map(value =>
          zio.aws.config.model.OrganizationAggregationSource.wrap(value)
        )
    override val tags: Option[List[zio.aws.config.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
  ): zio.aws.config.model.PutConfigurationAggregatorRequest.ReadOnly =
    new Wrapper(impl)
}
