package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAggregateDiscoveredResourcesResponse(
    resourceIdentifiers: Option[
      Iterable[zio.aws.config.model.AggregateResourceIdentifier]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse = {
    import ListAggregateDiscoveredResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse
      .builder()
      .optionallyWith(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly =
    zio.aws.config.model.ListAggregateDiscoveredResourcesResponse
      .wrap(buildAwsValue())
}
object ListAggregateDiscoveredResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.ListAggregateDiscoveredResourcesResponse =
      zio.aws.config.model.ListAggregateDiscoveredResourcesResponse(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceIdentifiers: Option[
      List[zio.aws.config.model.AggregateResourceIdentifier.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getResourceIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIdentifiers", resourceIdentifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse
  ) extends zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly {
    override val resourceIdentifiers: Option[
      List[zio.aws.config.model.AggregateResourceIdentifier.ReadOnly]
    ] = scala
      .Option(impl.resourceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregateResourceIdentifier.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse
  ): zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
