package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  BaseResourceId,
  StringWithCharLimit256,
  ConfigRuleName
}
import scala.jdk.CollectionConverters.*
final case class EvaluationResultQualifier(
    configRuleName: Option[ConfigRuleName] = None,
    resourceType: Option[StringWithCharLimit256] = None,
    resourceId: Option[BaseResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.EvaluationResultQualifier = {
    import EvaluationResultQualifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.EvaluationResultQualifier
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => BaseResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .build()
  }
  def asReadOnly: zio.aws.config.model.EvaluationResultQualifier.ReadOnly =
    zio.aws.config.model.EvaluationResultQualifier.wrap(buildAwsValue())
}
object EvaluationResultQualifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.EvaluationResultQualifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.EvaluationResultQualifier =
      zio.aws.config.model.EvaluationResultQualifier(
        configRuleName.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value)
      )
    def configRuleName: Option[ConfigRuleName]
    def resourceType: Option[StringWithCharLimit256]
    def resourceId: Option[BaseResourceId]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.EvaluationResultQualifier
  ) extends zio.aws.config.model.EvaluationResultQualifier.ReadOnly {
    override val configRuleName: Option[ConfigRuleName] = scala
      .Option(impl.configRuleName())
      .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val resourceType: Option[StringWithCharLimit256] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val resourceId: Option[BaseResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.EvaluationResultQualifier
  ): zio.aws.config.model.EvaluationResultQualifier.ReadOnly = new Wrapper(impl)
}
