package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigRulesResponse(
    organizationConfigRules: Option[
      Iterable[zio.aws.config.model.OrganizationConfigRule]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse = {
    import DescribeOrganizationConfigRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse
      .builder()
      .optionallyWith(
        organizationConfigRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationConfigRules)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConfigRulesResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConfigRulesResponse =
      zio.aws.config.model.DescribeOrganizationConfigRulesResponse(
        organizationConfigRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def organizationConfigRules
        : Option[List[zio.aws.config.model.OrganizationConfigRule.ReadOnly]]
    def nextToken: Option[String]
    def getOrganizationConfigRules: ZIO[Any, AwsError, List[
      zio.aws.config.model.OrganizationConfigRule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationConfigRules",
      organizationConfigRules
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse
  ) extends zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly {
    override val organizationConfigRules
        : Option[List[zio.aws.config.model.OrganizationConfigRule.ReadOnly]] =
      scala
        .Option(impl.organizationConfigRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.OrganizationConfigRule.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse
  ): zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly =
    new Wrapper(impl)
}
