package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationAggregatorsResponse(
    configurationAggregators: Option[
      Iterable[zio.aws.config.model.ConfigurationAggregator]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse = {
    import DescribeConfigurationAggregatorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse
      .builder()
      .optionallyWith(
        configurationAggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationAggregators)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly =
    zio.aws.config.model.DescribeConfigurationAggregatorsResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationAggregatorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigurationAggregatorsResponse =
      zio.aws.config.model.DescribeConfigurationAggregatorsResponse(
        configurationAggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configurationAggregators
        : Option[List[zio.aws.config.model.ConfigurationAggregator.ReadOnly]]
    def nextToken: Option[String]
    def getConfigurationAggregators: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConfigurationAggregator.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "configurationAggregators",
      configurationAggregators
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse
  ) extends zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly {
    override val configurationAggregators
        : Option[List[zio.aws.config.model.ConfigurationAggregator.ReadOnly]] =
      scala
        .Option(impl.configurationAggregators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ConfigurationAggregator.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse
  ): zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly =
    new Wrapper(impl)
}
