package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  NextToken,
  GroupByAPILimit,
  ConfigurationAggregatorName
}
import scala.jdk.CollectionConverters.*
final case class DescribeAggregateComplianceByConfigRulesRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    filters: Option[zio.aws.config.model.ConfigRuleComplianceFilters] = None,
    limit: Option[GroupByAPILimit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest = {
    import DescribeAggregateComplianceByConfigRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        limit.map(value => GroupByAPILimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest.ReadOnly =
    zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest
      .wrap(buildAwsValue())
}
object DescribeAggregateComplianceByConfigRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest =
      zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest(
        configurationAggregatorName,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def filters
        : Option[zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly]
    def limit: Option[GroupByAPILimit]
    def nextToken: Option[NextToken]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, GroupByAPILimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest
  ) extends zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val filters
        : Option[zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly] =
      scala
        .Option(impl.filters())
        .map(value =>
          zio.aws.config.model.ConfigRuleComplianceFilters.wrap(value)
        )
    override val limit: Option[GroupByAPILimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.GroupByAPILimit(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest
  ): zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest.ReadOnly =
    new Wrapper(impl)
}
