package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigRuleName
import scala.jdk.CollectionConverters.*
final case class DeleteRemediationConfigurationRequest(
    configRuleName: ConfigRuleName,
    resourceType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest = {
    import DeleteRemediationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DeleteRemediationConfigurationRequest.ReadOnly =
    zio.aws.config.model.DeleteRemediationConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteRemediationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteRemediationConfigurationRequest =
      zio.aws.config.model.DeleteRemediationConfigurationRequest(
        configRuleName,
        resourceType.map(value => value)
      )
    def configRuleName: ConfigRuleName
    def resourceType: Option[String]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest
  ) extends zio.aws.config.model.DeleteRemediationConfigurationRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val resourceType: Option[String] =
      scala.Option(impl.resourceType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest
  ): zio.aws.config.model.DeleteRemediationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
