package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Date
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ConfigurationRecorderStatus(
    name: Option[String] = None,
    lastStartTime: Option[Date] = None,
    lastStopTime: Option[Date] = None,
    recording: Option[Boolean] = None,
    lastStatus: Option[zio.aws.config.model.RecorderStatus] = None,
    lastErrorCode: Option[String] = None,
    lastErrorMessage: Option[String] = None,
    lastStatusChangeTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus = {
    import ConfigurationRecorderStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(lastStartTime.map(value => Date.unwrap(value): Instant))(
        _.lastStartTime
      )
      .optionallyWith(lastStopTime.map(value => Date.unwrap(value): Instant))(
        _.lastStopTime
      )
      .optionallyWith(recording.map(value => value: java.lang.Boolean))(
        _.recording
      )
      .optionallyWith(lastStatus.map(value => value.unwrap))(_.lastStatus)
      .optionallyWith(lastErrorCode.map(value => value: java.lang.String))(
        _.lastErrorCode
      )
      .optionallyWith(lastErrorMessage.map(value => value: java.lang.String))(
        _.lastErrorMessage
      )
      .optionallyWith(
        lastStatusChangeTime.map(value => Date.unwrap(value): Instant)
      )(_.lastStatusChangeTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly =
    zio.aws.config.model.ConfigurationRecorderStatus.wrap(buildAwsValue())
}
object ConfigurationRecorderStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigurationRecorderStatus =
      zio.aws.config.model.ConfigurationRecorderStatus(
        name.map(value => value),
        lastStartTime.map(value => value),
        lastStopTime.map(value => value),
        recording.map(value => value),
        lastStatus.map(value => value),
        lastErrorCode.map(value => value),
        lastErrorMessage.map(value => value),
        lastStatusChangeTime.map(value => value)
      )
    def name: Option[String]
    def lastStartTime: Option[Date]
    def lastStopTime: Option[Date]
    def recording: Option[Boolean]
    def lastStatus: Option[zio.aws.config.model.RecorderStatus]
    def lastErrorCode: Option[String]
    def lastErrorMessage: Option[String]
    def lastStatusChangeTime: Option[Date]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getLastStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastStartTime", lastStartTime)
    def getLastStopTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastStopTime", lastStopTime)
    def getRecording: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("recording", recording)
    def getLastStatus: ZIO[Any, AwsError, zio.aws.config.model.RecorderStatus] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLastErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorCode", lastErrorCode)
    def getLastErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorMessage", lastErrorMessage)
    def getLastStatusChangeTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastStatusChangeTime", lastStatusChangeTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
  ) extends zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val lastStartTime: Option[Date] = scala
      .Option(impl.lastStartTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastStopTime: Option[Date] = scala
      .Option(impl.lastStopTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val recording: Option[Boolean] =
      scala.Option(impl.recording()).map(value => value: Boolean)
    override val lastStatus: Option[zio.aws.config.model.RecorderStatus] = scala
      .Option(impl.lastStatus())
      .map(value => zio.aws.config.model.RecorderStatus.wrap(value))
    override val lastErrorCode: Option[String] =
      scala.Option(impl.lastErrorCode()).map(value => value: String)
    override val lastErrorMessage: Option[String] =
      scala.Option(impl.lastErrorMessage()).map(value => value: String)
    override val lastStatusChangeTime: Option[Date] = scala
      .Option(impl.lastStatusChangeTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
  ): zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly = new Wrapper(
    impl
  )
}
