package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.RecorderName
import scala.jdk.CollectionConverters.*
final case class ConfigurationRecorder(
    name: Option[RecorderName] = None,
    roleARN: Option[String] = None,
    recordingGroup: Option[zio.aws.config.model.RecordingGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigurationRecorder = {
    import ConfigurationRecorder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigurationRecorder
      .builder()
      .optionallyWith(
        name.map(value => RecorderName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(roleARN.map(value => value: java.lang.String))(_.roleARN)
      .optionallyWith(recordingGroup.map(value => value.buildAwsValue()))(
        _.recordingGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigurationRecorder.ReadOnly =
    zio.aws.config.model.ConfigurationRecorder.wrap(buildAwsValue())
}
object ConfigurationRecorder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigurationRecorder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigurationRecorder =
      zio.aws.config.model.ConfigurationRecorder(
        name.map(value => value),
        roleARN.map(value => value),
        recordingGroup.map(value => value.asEditable)
      )
    def name: Option[RecorderName]
    def roleARN: Option[String]
    def recordingGroup: Option[zio.aws.config.model.RecordingGroup.ReadOnly]
    def getName: ZIO[Any, AwsError, RecorderName] =
      AwsError.unwrapOptionField("name", name)
    def getRoleARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getRecordingGroup
        : ZIO[Any, AwsError, zio.aws.config.model.RecordingGroup.ReadOnly] =
      AwsError.unwrapOptionField("recordingGroup", recordingGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigurationRecorder
  ) extends zio.aws.config.model.ConfigurationRecorder.ReadOnly {
    override val name: Option[RecorderName] = scala
      .Option(impl.name())
      .map(value => zio.aws.config.model.primitives.RecorderName(value))
    override val roleARN: Option[String] =
      scala.Option(impl.roleARN()).map(value => value: String)
    override val recordingGroup
        : Option[zio.aws.config.model.RecordingGroup.ReadOnly] = scala
      .Option(impl.recordingGroup())
      .map(value => zio.aws.config.model.RecordingGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigurationRecorder
  ): zio.aws.config.model.ConfigurationRecorder.ReadOnly = new Wrapper(impl)
}
