package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ComplianceContributorCount(
    cappedCount: Option[Integer] = None,
    capExceeded: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceContributorCount = {
    import ComplianceContributorCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceContributorCount
      .builder()
      .optionallyWith(
        cappedCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.cappedCount)
      .optionallyWith(capExceeded.map(value => value: java.lang.Boolean))(
        _.capExceeded
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ComplianceContributorCount.ReadOnly =
    zio.aws.config.model.ComplianceContributorCount.wrap(buildAwsValue())
}
object ComplianceContributorCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceContributorCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceContributorCount =
      zio.aws.config.model.ComplianceContributorCount(
        cappedCount.map(value => value),
        capExceeded.map(value => value)
      )
    def cappedCount: Option[Integer]
    def capExceeded: Option[Boolean]
    def getCappedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cappedCount", cappedCount)
    def getCapExceeded: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("capExceeded", capExceeded)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceContributorCount
  ) extends zio.aws.config.model.ComplianceContributorCount.ReadOnly {
    override val cappedCount: Option[Integer] = scala
      .Option(impl.cappedCount())
      .map(value => zio.aws.config.model.primitives.Integer(value))
    override val capExceeded: Option[Boolean] =
      scala.Option(impl.capExceeded()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceContributorCount
  ): zio.aws.config.model.ComplianceContributorCount.ReadOnly = new Wrapper(
    impl
  )
}
