package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class AggregateConformancePackComplianceCount(
    compliantConformancePackCount: Option[Integer] = None,
    nonCompliantConformancePackCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceCount = {
    import AggregateConformancePackComplianceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceCount
      .builder()
      .optionallyWith(
        compliantConformancePackCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.compliantConformancePackCount)
      .optionallyWith(
        nonCompliantConformancePackCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantConformancePackCount)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly =
    zio.aws.config.model.AggregateConformancePackComplianceCount
      .wrap(buildAwsValue())
}
object AggregateConformancePackComplianceCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.AggregateConformancePackComplianceCount =
      zio.aws.config.model.AggregateConformancePackComplianceCount(
        compliantConformancePackCount.map(value => value),
        nonCompliantConformancePackCount.map(value => value)
      )
    def compliantConformancePackCount: Option[Integer]
    def nonCompliantConformancePackCount: Option[Integer]
    def getCompliantConformancePackCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "compliantConformancePackCount",
        compliantConformancePackCount
      )
    def getNonCompliantConformancePackCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "nonCompliantConformancePackCount",
        nonCompliantConformancePackCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceCount
  ) extends zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly {
    override val compliantConformancePackCount: Option[Integer] = scala
      .Option(impl.compliantConformancePackCount())
      .map(value => zio.aws.config.model.primitives.Integer(value))
    override val nonCompliantConformancePackCount: Option[Integer] = scala
      .Option(impl.nonCompliantConformancePackCount())
      .map(value => zio.aws.config.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceCount
  ): zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly =
    new Wrapper(impl)
}
