package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class AggregateConformancePackCompliance(
    complianceType: Option[zio.aws.config.model.ConformancePackComplianceType] =
      None,
    compliantRuleCount: Option[Integer] = None,
    nonCompliantRuleCount: Option[Integer] = None,
    totalRuleCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance = {
    import AggregateConformancePackCompliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
      .builder()
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        compliantRuleCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.compliantRuleCount)
      .optionallyWith(
        nonCompliantRuleCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nonCompliantRuleCount)
      .optionallyWith(
        totalRuleCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.totalRuleCount)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly =
    zio.aws.config.model.AggregateConformancePackCompliance
      .wrap(buildAwsValue())
}
object AggregateConformancePackCompliance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregateConformancePackCompliance =
      zio.aws.config.model.AggregateConformancePackCompliance(
        complianceType.map(value => value),
        compliantRuleCount.map(value => value),
        nonCompliantRuleCount.map(value => value),
        totalRuleCount.map(value => value)
      )
    def complianceType
        : Option[zio.aws.config.model.ConformancePackComplianceType]
    def compliantRuleCount: Option[Integer]
    def nonCompliantRuleCount: Option[Integer]
    def totalRuleCount: Option[Integer]
    def getComplianceType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceType
    ] = AwsError.unwrapOptionField("complianceType", complianceType)
    def getCompliantRuleCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantRuleCount", compliantRuleCount)
    def getNonCompliantRuleCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nonCompliantRuleCount", nonCompliantRuleCount)
    def getTotalRuleCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalRuleCount", totalRuleCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
  ) extends zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly {
    override val complianceType
        : Option[zio.aws.config.model.ConformancePackComplianceType] = scala
      .Option(impl.complianceType())
      .map(value =>
        zio.aws.config.model.ConformancePackComplianceType.wrap(value)
      )
    override val compliantRuleCount: Option[Integer] = scala
      .Option(impl.compliantRuleCount())
      .map(value => zio.aws.config.model.primitives.Integer(value))
    override val nonCompliantRuleCount: Option[Integer] = scala
      .Option(impl.nonCompliantRuleCount())
      .map(value => zio.aws.config.model.primitives.Integer(value))
    override val totalRuleCount: Option[Integer] = scala
      .Option(impl.totalRuleCount())
      .map(value => zio.aws.config.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
  ): zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly =
    new Wrapper(impl)
}
