package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationPreferenceName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName
}
object RecommendationPreferenceName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName
  ): zio.aws.computeoptimizer.model.RecommendationPreferenceName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.ENHANCED_INFRASTRUCTURE_METRICS =>
      val r = EnhancedInfrastructureMetrics
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.INFERRED_WORKLOAD_TYPES =>
      val r = InferredWorkloadTypes
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.EXTERNAL_METRICS_PREFERENCE =>
      val r = ExternalMetricsPreference
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.RecommendationPreferenceName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.UNKNOWN_TO_SDK_VERSION
  }
  case object EnhancedInfrastructureMetrics
      extends zio.aws.computeoptimizer.model.RecommendationPreferenceName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.ENHANCED_INFRASTRUCTURE_METRICS
  }
  case object InferredWorkloadTypes
      extends zio.aws.computeoptimizer.model.RecommendationPreferenceName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.INFERRED_WORKLOAD_TYPES
  }
  case object ExternalMetricsPreference
      extends zio.aws.computeoptimizer.model.RecommendationPreferenceName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName.EXTERNAL_METRICS_PREFERENCE
  }
}
