package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  LicenseVersion,
  OperatingSystem,
  InstanceType,
  NumberOfCores
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LicenseConfiguration(
    numberOfCores: Optional[NumberOfCores] = Optional.Absent,
    instanceType: Optional[InstanceType] = Optional.Absent,
    operatingSystem: Optional[OperatingSystem] = Optional.Absent,
    licenseEdition: Optional[zio.aws.computeoptimizer.model.LicenseEdition] =
      Optional.Absent,
    licenseName: Optional[zio.aws.computeoptimizer.model.LicenseName] =
      Optional.Absent,
    licenseModel: Optional[zio.aws.computeoptimizer.model.LicenseModel] =
      Optional.Absent,
    licenseVersion: Optional[LicenseVersion] = Optional.Absent,
    metricsSource: Optional[
      Iterable[zio.aws.computeoptimizer.model.MetricSource]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LicenseConfiguration = {
    import LicenseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LicenseConfiguration
      .builder()
      .optionallyWith(
        numberOfCores.map(value => NumberOfCores.unwrap(value): Integer)
      )(_.numberOfCores)
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        operatingSystem.map(value =>
          OperatingSystem.unwrap(value): java.lang.String
        )
      )(_.operatingSystem)
      .optionallyWith(licenseEdition.map(value => value.unwrap))(
        _.licenseEdition
      )
      .optionallyWith(licenseName.map(value => value.unwrap))(_.licenseName)
      .optionallyWith(licenseModel.map(value => value.unwrap))(_.licenseModel)
      .optionallyWith(
        licenseVersion.map(value =>
          LicenseVersion.unwrap(value): java.lang.String
        )
      )(_.licenseVersion)
      .optionallyWith(
        metricsSource.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricsSource)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.LicenseConfiguration.ReadOnly =
    zio.aws.computeoptimizer.model.LicenseConfiguration.wrap(buildAwsValue())
}
object LicenseConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LicenseConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.LicenseConfiguration =
      zio.aws.computeoptimizer.model.LicenseConfiguration(
        numberOfCores.map(value => value),
        instanceType.map(value => value),
        operatingSystem.map(value => value),
        licenseEdition.map(value => value),
        licenseName.map(value => value),
        licenseModel.map(value => value),
        licenseVersion.map(value => value),
        metricsSource.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numberOfCores: Optional[NumberOfCores]
    def instanceType: Optional[InstanceType]
    def operatingSystem: Optional[OperatingSystem]
    def licenseEdition: Optional[zio.aws.computeoptimizer.model.LicenseEdition]
    def licenseName: Optional[zio.aws.computeoptimizer.model.LicenseName]
    def licenseModel: Optional[zio.aws.computeoptimizer.model.LicenseModel]
    def licenseVersion: Optional[LicenseVersion]
    def metricsSource
        : Optional[List[zio.aws.computeoptimizer.model.MetricSource.ReadOnly]]
    def getNumberOfCores: ZIO[Any, AwsError, NumberOfCores] =
      AwsError.unwrapOptionField("numberOfCores", numberOfCores)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getOperatingSystem: ZIO[Any, AwsError, OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getLicenseEdition
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.LicenseEdition] =
      AwsError.unwrapOptionField("licenseEdition", licenseEdition)
    def getLicenseName
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.LicenseName] =
      AwsError.unwrapOptionField("licenseName", licenseName)
    def getLicenseModel
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.LicenseModel] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getLicenseVersion: ZIO[Any, AwsError, LicenseVersion] =
      AwsError.unwrapOptionField("licenseVersion", licenseVersion)
    def getMetricsSource: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.MetricSource.ReadOnly
    ]] = AwsError.unwrapOptionField("metricsSource", metricsSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LicenseConfiguration
  ) extends zio.aws.computeoptimizer.model.LicenseConfiguration.ReadOnly {
    override val numberOfCores: Optional[NumberOfCores] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfCores())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NumberOfCores(value)
      )
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceType(value)
      )
    override val operatingSystem: Optional[OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.OperatingSystem(value)
        )
    override val licenseEdition
        : Optional[zio.aws.computeoptimizer.model.LicenseEdition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseEdition())
        .map(value => zio.aws.computeoptimizer.model.LicenseEdition.wrap(value))
    override val licenseName
        : Optional[zio.aws.computeoptimizer.model.LicenseName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseName())
        .map(value => zio.aws.computeoptimizer.model.LicenseName.wrap(value))
    override val licenseModel
        : Optional[zio.aws.computeoptimizer.model.LicenseModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseModel())
        .map(value => zio.aws.computeoptimizer.model.LicenseModel.wrap(value))
    override val licenseVersion: Optional[LicenseVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseVersion())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LicenseVersion(value)
        )
    override val metricsSource
        : Optional[List[zio.aws.computeoptimizer.model.MetricSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsSource())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.MetricSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LicenseConfiguration
  ): zio.aws.computeoptimizer.model.LicenseConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
