package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait ExportableLicenseField {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField
}
object ExportableLicenseField {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField
  ): zio.aws.computeoptimizer.model.ExportableLicenseField = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.ACCOUNT_ID =>
      val r = AccountId
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RESOURCE_ARN =>
      val r = ResourceArn
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.LOOKBACK_PERIOD_IN_DAYS =>
      val r = LookbackPeriodInDays
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.LAST_REFRESH_TIMESTAMP =>
      val r = LastRefreshTimestamp
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.FINDING =>
      val r = Finding
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.FINDING_REASON_CODES =>
      val r = FindingReasonCodes
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_NUMBER_OF_CORES =>
      val r = CurrentLicenseConfigurationNumberOfCores
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_INSTANCE_TYPE =>
      val r = CurrentLicenseConfigurationInstanceType
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_OPERATING_SYSTEM =>
      val r = CurrentLicenseConfigurationOperatingSystem
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_NAME =>
      val r = CurrentLicenseConfigurationLicenseName
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_EDITION =>
      val r = CurrentLicenseConfigurationLicenseEdition
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_MODEL =>
      val r = CurrentLicenseConfigurationLicenseModel
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_VERSION =>
      val r = CurrentLicenseConfigurationLicenseVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_METRICS_SOURCE =>
      val r = CurrentLicenseConfigurationMetricsSource
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_OPERATING_SYSTEM =>
      val r = RecommendationOptionsOperatingSystem
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_LICENSE_EDITION =>
      val r = RecommendationOptionsLicenseEdition
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_LICENSE_MODEL =>
      val r = RecommendationOptionsLicenseModel
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE =>
      val r = RecommendationOptionsSavingsOpportunityPercentage
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY =>
      val r = RecommendationOptionsEstimatedMonthlySavingsCurrency
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE =>
      val r = RecommendationOptionsEstimatedMonthlySavingsValue
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.TAGS =>
      val r = Tags
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.UNKNOWN_TO_SDK_VERSION
  }
  case object AccountId
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.ACCOUNT_ID
  }
  case object ResourceArn
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RESOURCE_ARN
  }
  case object LookbackPeriodInDays
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.LOOKBACK_PERIOD_IN_DAYS
  }
  case object LastRefreshTimestamp
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.LAST_REFRESH_TIMESTAMP
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.FINDING
  }
  case object FindingReasonCodes
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.FINDING_REASON_CODES
  }
  case object CurrentLicenseConfigurationNumberOfCores
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_NUMBER_OF_CORES
  }
  case object CurrentLicenseConfigurationInstanceType
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_INSTANCE_TYPE
  }
  case object CurrentLicenseConfigurationOperatingSystem
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_OPERATING_SYSTEM
  }
  case object CurrentLicenseConfigurationLicenseName
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_NAME
  }
  case object CurrentLicenseConfigurationLicenseEdition
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_EDITION
  }
  case object CurrentLicenseConfigurationLicenseModel
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_MODEL
  }
  case object CurrentLicenseConfigurationLicenseVersion
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_LICENSE_VERSION
  }
  case object CurrentLicenseConfigurationMetricsSource
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.CURRENT_LICENSE_CONFIGURATION_METRICS_SOURCE
  }
  case object RecommendationOptionsOperatingSystem
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_OPERATING_SYSTEM
  }
  case object RecommendationOptionsLicenseEdition
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_LICENSE_EDITION
  }
  case object RecommendationOptionsLicenseModel
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_LICENSE_MODEL
  }
  case object RecommendationOptionsSavingsOpportunityPercentage
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE
  }
  case object RecommendationOptionsEstimatedMonthlySavingsCurrency
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY
  }
  case object RecommendationOptionsEstimatedMonthlySavingsValue
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE
  }
  case object Tags
      extends zio.aws.computeoptimizer.model.ExportableLicenseField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableLicenseField.TAGS
  }
}
