package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  AccountId,
  MaxResults,
  NextToken,
  ResourceArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetLicenseRecommendationsRequest(
    resourceArns: Optional[Iterable[ResourceArn]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.computeoptimizer.model.LicenseRecommendationFilter]
    ] = Optional.Absent,
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsRequest = {
    import GetLicenseRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsRequest
      .builder()
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetLicenseRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetLicenseRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetLicenseRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetLicenseRecommendationsRequest =
      zio.aws.computeoptimizer.model.GetLicenseRecommendationsRequest(
        resourceArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accountIds.map(value => value)
      )
    def resourceArns: Optional[List[ResourceArn]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filters: Optional[
      List[zio.aws.computeoptimizer.model.LicenseRecommendationFilter.ReadOnly]
    ]
    def accountIds: Optional[List[AccountId]]
    def getResourceArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LicenseRecommendationFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.GetLicenseRecommendationsRequest.ReadOnly {
    override val resourceArns: Optional[List[ResourceArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.primitives.ResourceArn(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
    override val filters: Optional[
      List[zio.aws.computeoptimizer.model.LicenseRecommendationFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LicenseRecommendationFilter.wrap(item)
        }.toList
      )
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsRequest
  ): zio.aws.computeoptimizer.model.GetLicenseRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
