package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{MaxResults, NextToken, JobId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeRecommendationExportJobsRequest(
    jobIds: Optional[Iterable[JobId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.computeoptimizer.model.JobFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest = {
    import DescribeRecommendationExportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
      .builder()
      .optionallyWith(
        jobIds.map(value =>
          value.map { item =>
            JobId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest
      .wrap(buildAwsValue())
}
object DescribeRecommendationExportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest =
      zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest(
        jobIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def jobIds: Optional[List[JobId]]
    def filters
        : Optional[List[zio.aws.computeoptimizer.model.JobFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getJobIds: ZIO[Any, AwsError, List[JobId]] =
      AwsError.unwrapOptionField("jobIds", jobIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.JobFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
  ) extends zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest.ReadOnly {
    override val jobIds: Optional[List[JobId]] = zio.aws.core.internal
      .optionalFromNullable(impl.jobIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.JobId(item)
        }.toList
      )
    override val filters
        : Optional[List[zio.aws.computeoptimizer.model.JobFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.JobFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest
  ): zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsRequest.ReadOnly =
    new Wrapper(impl)
}
