package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait LambdaFunctionRecommendationFilterName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName
}
object LambdaFunctionRecommendationFilterName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName
  ): zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName.FINDING =>
        val r = Finding
        r
      case software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName.FINDING_REASON_CODE =>
        val r = FindingReasonCode
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName.FINDING
  }
  case object FindingReasonCode
      extends zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilterName.FINDING_REASON_CODE
  }
}
