package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class GetEcsServiceRecommendationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    ecsServiceRecommendations: Optional[
      Iterable[zio.aws.computeoptimizer.model.ECSServiceRecommendation]
    ] = Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.computeoptimizer.model.GetRecommendationError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse = {
    import GetEcsServiceRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ecsServiceRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecsServiceRecommendations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetEcsServiceRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse =
      zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse(
        nextToken.map(value => value),
        ecsServiceRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def ecsServiceRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.ECSServiceRecommendation.ReadOnly]
    ]
    def errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getEcsServiceRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ecsServiceRecommendations",
      ecsServiceRecommendations
    )
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val ecsServiceRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.ECSServiceRecommendation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecsServiceRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ECSServiceRecommendation.wrap(item)
        }.toList
      )
    override val errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.GetRecommendationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse
  ): zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
