package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait LicenseName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.LicenseName
}
object LicenseName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LicenseName
  ): zio.aws.computeoptimizer.model.LicenseName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseName.SQL_SERVER =>
      val r = SQLServer
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LicenseName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseName =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseName.UNKNOWN_TO_SDK_VERSION
  }
  case object SQLServer extends zio.aws.computeoptimizer.model.LicenseName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseName =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseName.SQL_SERVER
  }
}
