package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait MetricSourceProvider {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider
}
object MetricSourceProvider {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider
  ): zio.aws.computeoptimizer.model.MetricSourceProvider = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider.CLOUD_WATCH_APPLICATION_INSIGHTS =>
      val r = CloudWatchApplicationInsights
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.MetricSourceProvider {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider =
      software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider.UNKNOWN_TO_SDK_VERSION
  }
  case object CloudWatchApplicationInsights
      extends zio.aws.computeoptimizer.model.MetricSourceProvider {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider =
      software.amazon.awssdk.services.computeoptimizer.model.MetricSourceProvider.CLOUD_WATCH_APPLICATION_INSIGHTS
  }
}
