package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  AccountId,
  ResourceArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class LicenseRecommendation(
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    currentLicenseConfiguration: Optional[
      zio.aws.computeoptimizer.model.LicenseConfiguration
    ] = Optional.Absent,
    lookbackPeriodInDays: Optional[LookBackPeriodInDays] = Optional.Absent,
    lastRefreshTimestamp: Optional[LastRefreshTimestamp] = Optional.Absent,
    finding: Optional[zio.aws.computeoptimizer.model.LicenseFinding] =
      Optional.Absent,
    findingReasonCodes: Optional[
      Iterable[zio.aws.computeoptimizer.model.LicenseFindingReasonCode]
    ] = Optional.Absent,
    licenseRecommendationOptions: Optional[
      Iterable[zio.aws.computeoptimizer.model.LicenseRecommendationOption]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.computeoptimizer.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendation = {
    import LicenseRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendation
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        currentLicenseConfiguration.map(value => value.buildAwsValue())
      )(_.currentLicenseConfiguration)
      .optionallyWith(
        lookbackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookbackPeriodInDays)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        findingReasonCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingReasonCodesWithStrings)
      .optionallyWith(
        licenseRecommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseRecommendationOptions)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LicenseRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.LicenseRecommendation.wrap(buildAwsValue())
}
object LicenseRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.LicenseRecommendation =
      zio.aws.computeoptimizer.model.LicenseRecommendation(
        resourceArn.map(value => value),
        accountId.map(value => value),
        currentLicenseConfiguration.map(value => value.asEditable),
        lookbackPeriodInDays.map(value => value),
        lastRefreshTimestamp.map(value => value),
        finding.map(value => value),
        findingReasonCodes.map(value => value),
        licenseRecommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Optional[ResourceArn]
    def accountId: Optional[AccountId]
    def currentLicenseConfiguration
        : Optional[zio.aws.computeoptimizer.model.LicenseConfiguration.ReadOnly]
    def lookbackPeriodInDays: Optional[LookBackPeriodInDays]
    def lastRefreshTimestamp: Optional[LastRefreshTimestamp]
    def finding: Optional[zio.aws.computeoptimizer.model.LicenseFinding]
    def findingReasonCodes: Optional[
      List[zio.aws.computeoptimizer.model.LicenseFindingReasonCode]
    ]
    def licenseRecommendationOptions: Optional[
      List[zio.aws.computeoptimizer.model.LicenseRecommendationOption.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.computeoptimizer.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCurrentLicenseConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.LicenseConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentLicenseConfiguration",
      currentLicenseConfiguration
    )
    def getLookbackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookbackPeriodInDays", lookbackPeriodInDays)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getFinding
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.LicenseFinding] =
      AwsError.unwrapOptionField("finding", finding)
    def getFindingReasonCodes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LicenseFindingReasonCode
    ]] = AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodes)
    def getLicenseRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.LicenseRecommendationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "licenseRecommendationOptions",
      licenseRecommendationOptions
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendation
  ) extends zio.aws.computeoptimizer.model.LicenseRecommendation.ReadOnly {
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.ResourceArn(value)
      )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val currentLicenseConfiguration: Optional[
      zio.aws.computeoptimizer.model.LicenseConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentLicenseConfiguration())
      .map(value =>
        zio.aws.computeoptimizer.model.LicenseConfiguration.wrap(value)
      )
    override val lookbackPeriodInDays: Optional[LookBackPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookbackPeriodInDays())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
        )
    override val lastRefreshTimestamp: Optional[LastRefreshTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRefreshTimestamp())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
        )
    override val finding
        : Optional[zio.aws.computeoptimizer.model.LicenseFinding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finding())
        .map(value => zio.aws.computeoptimizer.model.LicenseFinding.wrap(value))
    override val findingReasonCodes: Optional[
      List[zio.aws.computeoptimizer.model.LicenseFindingReasonCode]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.findingReasonCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LicenseFindingReasonCode.wrap(item)
        }.toList
      )
    override val licenseRecommendationOptions: Optional[
      List[zio.aws.computeoptimizer.model.LicenseRecommendationOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseRecommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.LicenseRecommendationOption.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.computeoptimizer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendation
  ): zio.aws.computeoptimizer.model.LicenseRecommendation.ReadOnly =
    new Wrapper(impl)
}
