package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait JobFilterName {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.JobFilterName
}
object JobFilterName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.JobFilterName
  ): zio.aws.computeoptimizer.model.JobFilterName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.JobFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.JobFilterName.RESOURCE_TYPE =>
      val r = ResourceType
      r
    case software.amazon.awssdk.services.computeoptimizer.model.JobFilterName.JOB_STATUS =>
      val r = JobStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.JobFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.JobFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object ResourceType
      extends zio.aws.computeoptimizer.model.JobFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.JobFilterName.RESOURCE_TYPE
  }
  case object JobStatus extends zio.aws.computeoptimizer.model.JobFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.JobFilterName.JOB_STATUS
  }
}
