package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{GpuMemorySizeInMiB, GpuCount}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Gpu(
    gpuCount: Optional[GpuCount] = Optional.Absent,
    gpuMemorySizeInMiB: Optional[GpuMemorySizeInMiB] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.Gpu = {
    import Gpu.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.Gpu
      .builder()
      .optionallyWith(gpuCount.map(value => GpuCount.unwrap(value): Integer))(
        _.gpuCount
      )
      .optionallyWith(
        gpuMemorySizeInMiB.map(value =>
          GpuMemorySizeInMiB.unwrap(value): Integer
        )
      )(_.gpuMemorySizeInMiB)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.Gpu.ReadOnly =
    zio.aws.computeoptimizer.model.Gpu.wrap(buildAwsValue())
}
object Gpu {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.Gpu
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.Gpu =
      zio.aws.computeoptimizer.model.Gpu(
        gpuCount.map(value => value),
        gpuMemorySizeInMiB.map(value => value)
      )
    def gpuCount: Optional[GpuCount]
    def gpuMemorySizeInMiB: Optional[GpuMemorySizeInMiB]
    def getGpuCount: ZIO[Any, AwsError, GpuCount] =
      AwsError.unwrapOptionField("gpuCount", gpuCount)
    def getGpuMemorySizeInMiB: ZIO[Any, AwsError, GpuMemorySizeInMiB] =
      AwsError.unwrapOptionField("gpuMemorySizeInMiB", gpuMemorySizeInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Gpu
  ) extends zio.aws.computeoptimizer.model.Gpu.ReadOnly {
    override val gpuCount: Optional[GpuCount] = zio.aws.core.internal
      .optionalFromNullable(impl.gpuCount())
      .map(value => zio.aws.computeoptimizer.model.primitives.GpuCount(value))
    override val gpuMemorySizeInMiB: Optional[GpuMemorySizeInMiB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gpuMemorySizeInMiB())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.GpuMemorySizeInMiB(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Gpu
  ): zio.aws.computeoptimizer.model.Gpu.ReadOnly = new Wrapper(impl)
}
