package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait LicenseFinding {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding
}
object LicenseFinding {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding
  ): zio.aws.computeoptimizer.model.LicenseFinding = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.INSUFFICIENT_METRICS =>
      val r = InsufficientMetrics
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.OPTIMIZED =>
      val r = Optimized
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.NOT_OPTIMIZED =>
      val r = NotOptimized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LicenseFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.UNKNOWN_TO_SDK_VERSION
  }
  case object InsufficientMetrics
      extends zio.aws.computeoptimizer.model.LicenseFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.INSUFFICIENT_METRICS
  }
  case object Optimized extends zio.aws.computeoptimizer.model.LicenseFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.OPTIMIZED
  }
  case object NotOptimized
      extends zio.aws.computeoptimizer.model.LicenseFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseFinding.NOT_OPTIMIZED
  }
}
