package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  AutoScalingGroupArn,
  AccountId,
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  AutoScalingGroupName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AutoScalingGroupRecommendation(
    accountId: Optional[AccountId] = Optional.Absent,
    autoScalingGroupArn: Optional[AutoScalingGroupArn] = Optional.Absent,
    autoScalingGroupName: Optional[AutoScalingGroupName] = Optional.Absent,
    finding: Optional[zio.aws.computeoptimizer.model.Finding] = Optional.Absent,
    utilizationMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = Optional.Absent,
    lookBackPeriodInDays: Optional[LookBackPeriodInDays] = Optional.Absent,
    currentConfiguration: Optional[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration
    ] = Optional.Absent,
    recommendationOptions: Optional[Iterable[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption
    ]] = Optional.Absent,
    lastRefreshTimestamp: Optional[LastRefreshTimestamp] = Optional.Absent,
    currentPerformanceRisk: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = Optional.Absent,
    effectiveRecommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
    ] = Optional.Absent,
    inferredWorkloadTypes: Optional[
      Iterable[zio.aws.computeoptimizer.model.InferredWorkloadType]
    ] = Optional.Absent,
    currentInstanceGpuInfo: Optional[zio.aws.computeoptimizer.model.GpuInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation = {
    import AutoScalingGroupRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        autoScalingGroupArn.map(value =>
          AutoScalingGroupArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroupArn)
      .optionallyWith(
        autoScalingGroupName.map(value =>
          AutoScalingGroupName.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroupName)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookBackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookBackPeriodInDays)
      .optionallyWith(currentConfiguration.map(value => value.buildAwsValue()))(
        _.currentConfiguration
      )
      .optionallyWith(
        recommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationOptions)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .optionallyWith(
        effectiveRecommendationPreferences.map(value => value.buildAwsValue())
      )(_.effectiveRecommendationPreferences)
      .optionallyWith(
        inferredWorkloadTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inferredWorkloadTypesWithStrings)
      .optionallyWith(
        currentInstanceGpuInfo.map(value => value.buildAwsValue())
      )(_.currentInstanceGpuInfo)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation
      .wrap(buildAwsValue())
}
object AutoScalingGroupRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation =
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation(
        accountId.map(value => value),
        autoScalingGroupArn.map(value => value),
        autoScalingGroupName.map(value => value),
        finding.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookBackPeriodInDays.map(value => value),
        currentConfiguration.map(value => value.asEditable),
        recommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRefreshTimestamp.map(value => value),
        currentPerformanceRisk.map(value => value),
        effectiveRecommendationPreferences.map(value => value.asEditable),
        inferredWorkloadTypes.map(value => value),
        currentInstanceGpuInfo.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def autoScalingGroupArn: Optional[AutoScalingGroupArn]
    def autoScalingGroupName: Optional[AutoScalingGroupName]
    def finding: Optional[zio.aws.computeoptimizer.model.Finding]
    def utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def lookBackPeriodInDays: Optional[LookBackPeriodInDays]
    def currentConfiguration: Optional[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ]
    def recommendationOptions: Optional[List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly
    ]]
    def lastRefreshTimestamp: Optional[LastRefreshTimestamp]
    def currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def effectiveRecommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ]
    def inferredWorkloadTypes
        : Optional[List[zio.aws.computeoptimizer.model.InferredWorkloadType]]
    def currentInstanceGpuInfo
        : Optional[zio.aws.computeoptimizer.model.GpuInfo.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAutoScalingGroupArn: ZIO[Any, AwsError, AutoScalingGroupArn] =
      AwsError.unwrapOptionField("autoScalingGroupArn", autoScalingGroupArn)
    def getAutoScalingGroupName: ZIO[Any, AwsError, AutoScalingGroupName] =
      AwsError.unwrapOptionField("autoScalingGroupName", autoScalingGroupName)
    def getFinding: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Finding] =
      AwsError.unwrapOptionField("finding", finding)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookBackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookBackPeriodInDays", lookBackPeriodInDays)
    def getCurrentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("currentConfiguration", currentConfiguration)
    def getRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("recommendationOptions", recommendationOptions)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
    def getEffectiveRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "effectiveRecommendationPreferences",
      effectiveRecommendationPreferences
    )
    def getInferredWorkloadTypes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InferredWorkloadType
    ]] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
    def getCurrentInstanceGpuInfo
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.GpuInfo.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentInstanceGpuInfo",
        currentInstanceGpuInfo
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
  ) extends zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val autoScalingGroupArn: Optional[AutoScalingGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroupArn())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.AutoScalingGroupArn(value)
        )
    override val autoScalingGroupName: Optional[AutoScalingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroupName())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.AutoScalingGroupName(value)
        )
    override val finding: Optional[zio.aws.computeoptimizer.model.Finding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finding())
        .map(value => zio.aws.computeoptimizer.model.Finding.wrap(value))
    override val utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val lookBackPeriodInDays: Optional[LookBackPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookBackPeriodInDays())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
        )
    override val currentConfiguration: Optional[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentConfiguration())
      .map(value =>
        zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.wrap(value)
      )
    override val recommendationOptions: Optional[List[
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption
            .wrap(item)
        }.toList
      )
    override val lastRefreshTimestamp: Optional[LastRefreshTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRefreshTimestamp())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
        )
    override val currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPerformanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
        )
    override val effectiveRecommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveRecommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
          .wrap(value)
      )
    override val inferredWorkloadTypes
        : Optional[List[zio.aws.computeoptimizer.model.InferredWorkloadType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferredWorkloadTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.InferredWorkloadType.wrap(item)
          }.toList
        )
    override val currentInstanceGpuInfo
        : Optional[zio.aws.computeoptimizer.model.GpuInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInstanceGpuInfo())
        .map(value => zio.aws.computeoptimizer.model.GpuInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendation
  ): zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation.ReadOnly =
    new Wrapper(impl)
}
