package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.MetricProviderArn
import scala.jdk.CollectionConverters.*
final case class MetricSource(
    provider: Optional[zio.aws.computeoptimizer.model.MetricSourceProvider] =
      Optional.Absent,
    providerArn: Optional[MetricProviderArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.MetricSource = {
    import MetricSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.MetricSource
      .builder()
      .optionallyWith(provider.map(value => value.unwrap))(_.provider)
      .optionallyWith(
        providerArn.map(value =>
          MetricProviderArn.unwrap(value): java.lang.String
        )
      )(_.providerArn)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.MetricSource.ReadOnly =
    zio.aws.computeoptimizer.model.MetricSource.wrap(buildAwsValue())
}
object MetricSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.MetricSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.MetricSource =
      zio.aws.computeoptimizer.model.MetricSource(
        provider.map(value => value),
        providerArn.map(value => value)
      )
    def provider: Optional[zio.aws.computeoptimizer.model.MetricSourceProvider]
    def providerArn: Optional[MetricProviderArn]
    def getProvider: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.MetricSourceProvider
    ] = AwsError.unwrapOptionField("provider", provider)
    def getProviderArn: ZIO[Any, AwsError, MetricProviderArn] =
      AwsError.unwrapOptionField("providerArn", providerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.MetricSource
  ) extends zio.aws.computeoptimizer.model.MetricSource.ReadOnly {
    override val provider
        : Optional[zio.aws.computeoptimizer.model.MetricSourceProvider] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provider())
        .map(value =>
          zio.aws.computeoptimizer.model.MetricSourceProvider.wrap(value)
        )
    override val providerArn: Optional[MetricProviderArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerArn())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.MetricProviderArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.MetricSource
  ): zio.aws.computeoptimizer.model.MetricSource.ReadOnly = new Wrapper(impl)
}
