package zio.aws.computeoptimizer
import zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly
import zio.aws.computeoptimizer.model.{
  GetEnrollmentStatusesForOrganizationRequest,
  UpdateEnrollmentStatusRequest,
  ExportLambdaFunctionRecommendationsRequest,
  GetLicenseRecommendationsRequest,
  DeleteRecommendationPreferencesRequest,
  GetEffectiveRecommendationPreferencesRequest,
  GetEnrollmentStatusRequest,
  GetRecommendationPreferencesRequest,
  GetAutoScalingGroupRecommendationsRequest,
  ExportEc2InstanceRecommendationsRequest,
  GetEc2RecommendationProjectedMetricsRequest,
  DescribeRecommendationExportJobsRequest,
  GetLambdaFunctionRecommendationsRequest,
  ExportLicenseRecommendationsRequest,
  ExportEcsServiceRecommendationsRequest,
  GetEcsServiceRecommendationsRequest,
  ExportAutoScalingGroupRecommendationsRequest,
  PutRecommendationPreferencesRequest,
  GetRecommendationSummariesRequest,
  GetEcsServiceRecommendationProjectedMetricsRequest,
  GetEc2InstanceRecommendationsRequest,
  GetEbsVolumeRecommendationsRequest,
  ExportEbsVolumeRecommendationsRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.computeoptimizer.model.{
  GetEffectiveRecommendationPreferencesResponse,
  UpdateEnrollmentStatusResponse,
  GetLambdaFunctionRecommendationsResponse,
  RecommendationSummary,
  RecommendationPreferencesDetail,
  GetAutoScalingGroupRecommendationsResponse,
  RecommendationExportJob,
  ExportEcsServiceRecommendationsResponse,
  GetEbsVolumeRecommendationsResponse,
  ExportEbsVolumeRecommendationsResponse,
  GetEnrollmentStatusesForOrganizationResponse,
  GetEc2RecommendationProjectedMetricsResponse,
  GetEnrollmentStatusResponse,
  GetRecommendationSummariesResponse,
  GetEc2InstanceRecommendationsResponse,
  GetEcsServiceRecommendationsResponse,
  ExportEc2InstanceRecommendationsResponse,
  LambdaFunctionRecommendation,
  ExportLambdaFunctionRecommendationsResponse,
  GetLicenseRecommendationsResponse,
  GetEcsServiceRecommendationProjectedMetricsResponse,
  PutRecommendationPreferencesResponse,
  ExportAutoScalingGroupRecommendationsResponse,
  DescribeRecommendationExportJobsResponse,
  AccountEnrollmentStatus,
  ExportLicenseRecommendationsResponse,
  DeleteRecommendationPreferencesResponse,
  GetRecommendationPreferencesResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.computeoptimizer.paginators.{
  GetRecommendationPreferencesPublisher,
  DescribeRecommendationExportJobsPublisher,
  GetRecommendationSummariesPublisher,
  GetLambdaFunctionRecommendationsPublisher,
  GetEnrollmentStatusesForOrganizationPublisher
}
import software.amazon.awssdk.services.computeoptimizer.{
  ComputeOptimizerAsyncClientBuilder,
  ComputeOptimizerAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ComputeOptimizer extends AspectSupport[ComputeOptimizer] {
  val api: ComputeOptimizerAsyncClient
  def getEBSVolumeRecommendations(
      request: GetEbsVolumeRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly
  ]
  def getECSServiceRecommendationProjectedMetrics(
      request: GetEcsServiceRecommendationProjectedMetricsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly
  ]
  def getEC2RecommendationProjectedMetrics(
      request: GetEc2RecommendationProjectedMetricsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly
  ]
  def exportLambdaFunctionRecommendations(
      request: ExportLambdaFunctionRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly
  ]
  def deleteRecommendationPreferences(
      request: DeleteRecommendationPreferencesRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.ReadOnly
  ]
  def exportECSServiceRecommendations(
      request: ExportEcsServiceRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.ExportEcsServiceRecommendationsResponse.ReadOnly
  ]
  def exportEC2InstanceRecommendations(
      request: ExportEc2InstanceRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.ReadOnly
  ]
  def getEnrollmentStatusesForOrganization(
      request: GetEnrollmentStatusesForOrganizationRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly
  ]
  def getEnrollmentStatusesForOrganizationPaginated(
      request: GetEnrollmentStatusesForOrganizationRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly
  ]
  def putRecommendationPreferences(
      request: PutRecommendationPreferencesRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.ReadOnly
  ]
  def getECSServiceRecommendations(
      request: GetEcsServiceRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly
  ]
  def getEffectiveRecommendationPreferences(
      request: GetEffectiveRecommendationPreferencesRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly
  ]
  def getEnrollmentStatus(request: GetEnrollmentStatusRequest): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly
  ]
  def getEC2InstanceRecommendations(
      request: GetEc2InstanceRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly
  ]
  def getAutoScalingGroupRecommendations(
      request: GetAutoScalingGroupRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly
  ]
  def updateEnrollmentStatus(request: UpdateEnrollmentStatusRequest): IO[
    AwsError,
    zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly
  ]
  def getLambdaFunctionRecommendations(
      request: GetLambdaFunctionRecommendationsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def getLambdaFunctionRecommendationsPaginated(
      request: GetLambdaFunctionRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly
  ]
  def exportEBSVolumeRecommendations(
      request: ExportEbsVolumeRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.ReadOnly
  ]
  def exportAutoScalingGroupRecommendations(
      request: ExportAutoScalingGroupRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.ReadOnly
  ]
  def getLicenseRecommendations(request: GetLicenseRecommendationsRequest): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse.ReadOnly
  ]
  def exportLicenseRecommendations(
      request: ExportLicenseRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.ExportLicenseRecommendationsResponse.ReadOnly
  ]
  def describeRecommendationExportJobs(
      request: DescribeRecommendationExportJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly
  ]
  def describeRecommendationExportJobsPaginated(
      request: DescribeRecommendationExportJobsRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly
  ]
  def getRecommendationPreferences(
      request: GetRecommendationPreferencesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
  ]
  def getRecommendationPreferencesPaginated(
      request: GetRecommendationPreferencesRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly
  ]
  def getRecommendationSummaries(
      request: GetRecommendationSummariesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly
  ]
  def getRecommendationSummariesPaginated(
      request: GetRecommendationSummariesRequest
  ): IO[
    AwsError,
    zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly
  ]
}
object ComputeOptimizer {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ComputeOptimizer] =
    customized(identity)
  def customized(
      customization: ComputeOptimizerAsyncClientBuilder => ComputeOptimizerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ComputeOptimizer] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ComputeOptimizerAsyncClientBuilder => ComputeOptimizerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ComputeOptimizer] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ComputeOptimizerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      ComputeOptimizerAsyncClient,
      ComputeOptimizerAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      ComputeOptimizerAsyncClient,
      ComputeOptimizerAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ComputeOptimizerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ComputeOptimizerImpl[R](
      override val api: ComputeOptimizerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ComputeOptimizer
      with AwsServiceBase[R] {
    override val serviceName: String = "ComputeOptimizer"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ComputeOptimizerImpl[R1] = new ComputeOptimizerImpl(api, newAspect, r)
    def getEBSVolumeRecommendations(
        request: GetEbsVolumeRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest,
      GetEbsVolumeRecommendationsResponse
    ]("getEBSVolumeRecommendations", api.getEBSVolumeRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def getECSServiceRecommendationProjectedMetrics(
        request: GetEcsServiceRecommendationProjectedMetricsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest,
      GetEcsServiceRecommendationProjectedMetricsResponse
    ](
      "getECSServiceRecommendationProjectedMetrics",
      api.getECSServiceRecommendationProjectedMetrics
    )(request.buildAwsValue())
      .map(
        zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.wrap
      )
      .provideEnvironment(r)
    def getEC2RecommendationProjectedMetrics(
        request: GetEc2RecommendationProjectedMetricsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest,
      GetEc2RecommendationProjectedMetricsResponse
    ](
      "getEC2RecommendationProjectedMetrics",
      api.getEC2RecommendationProjectedMetrics
    )(request.buildAwsValue())
      .map(
        zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.wrap
      )
      .provideEnvironment(r)
    def exportLambdaFunctionRecommendations(
        request: ExportLambdaFunctionRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest,
      ExportLambdaFunctionRecommendationsResponse
    ](
      "exportLambdaFunctionRecommendations",
      api.exportLambdaFunctionRecommendations
    )(request.buildAwsValue())
      .map(
        zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteRecommendationPreferences(
        request: DeleteRecommendationPreferencesRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest,
      DeleteRecommendationPreferencesResponse
    ]("deleteRecommendationPreferences", api.deleteRecommendationPreferences)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.wrap
    ).provideEnvironment(r)
    def exportECSServiceRecommendations(
        request: ExportEcsServiceRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.ExportEcsServiceRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.ExportEcsServiceRecommendationsRequest,
      ExportEcsServiceRecommendationsResponse
    ]("exportECSServiceRecommendations", api.exportECSServiceRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.ExportEcsServiceRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def exportEC2InstanceRecommendations(
        request: ExportEc2InstanceRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest,
      ExportEc2InstanceRecommendationsResponse
    ]("exportEC2InstanceRecommendations", api.exportEC2InstanceRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def getEnrollmentStatusesForOrganization(
        request: GetEnrollmentStatusesForOrganizationRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest,
      AccountEnrollmentStatus,
      GetEnrollmentStatusesForOrganizationPublisher
    ](
      "getEnrollmentStatusesForOrganization",
      api.getEnrollmentStatusesForOrganizationPaginator,
      _.accountEnrollmentStatuses()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.computeoptimizer.model.AccountEnrollmentStatus.wrap(item)
      )
      .provideEnvironment(r)
    def getEnrollmentStatusesForOrganizationPaginated(
        request: GetEnrollmentStatusesForOrganizationRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest,
      GetEnrollmentStatusesForOrganizationResponse
    ](
      "getEnrollmentStatusesForOrganization",
      api.getEnrollmentStatusesForOrganization
    )(request.buildAwsValue())
      .map(
        zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.wrap
      )
      .provideEnvironment(r)
    def putRecommendationPreferences(
        request: PutRecommendationPreferencesRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest,
      PutRecommendationPreferencesResponse
    ]("putRecommendationPreferences", api.putRecommendationPreferences)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.wrap
    ).provideEnvironment(r)
    def getECSServiceRecommendations(
        request: GetEcsServiceRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest,
      GetEcsServiceRecommendationsResponse
    ]("getECSServiceRecommendations", api.getECSServiceRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def getEffectiveRecommendationPreferences(
        request: GetEffectiveRecommendationPreferencesRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest,
      GetEffectiveRecommendationPreferencesResponse
    ](
      "getEffectiveRecommendationPreferences",
      api.getEffectiveRecommendationPreferences
    )(request.buildAwsValue())
      .map(
        zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.wrap
      )
      .provideEnvironment(r)
    def getEnrollmentStatus(request: GetEnrollmentStatusRequest): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusRequest,
      GetEnrollmentStatusResponse
    ]("getEnrollmentStatus", api.getEnrollmentStatus)(request.buildAwsValue())
      .map(zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.wrap)
      .provideEnvironment(r)
    def getEC2InstanceRecommendations(
        request: GetEc2InstanceRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest,
      GetEc2InstanceRecommendationsResponse
    ]("getEC2InstanceRecommendations", api.getEC2InstanceRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def getAutoScalingGroupRecommendations(
        request: GetAutoScalingGroupRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest,
      GetAutoScalingGroupRecommendationsResponse
    ](
      "getAutoScalingGroupRecommendations",
      api.getAutoScalingGroupRecommendations
    )(request.buildAwsValue())
      .map(
        zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.wrap
      )
      .provideEnvironment(r)
    def updateEnrollmentStatus(request: UpdateEnrollmentStatusRequest): IO[
      AwsError,
      zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest,
      UpdateEnrollmentStatusResponse
    ]("updateEnrollmentStatus", api.updateEnrollmentStatus)(
      request.buildAwsValue()
    ).map(zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.wrap)
      .provideEnvironment(r)
    def getLambdaFunctionRecommendations(
        request: GetLambdaFunctionRecommendationsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest,
      LambdaFunctionRecommendation,
      GetLambdaFunctionRecommendationsPublisher
    ](
      "getLambdaFunctionRecommendations",
      api.getLambdaFunctionRecommendationsPaginator,
      _.lambdaFunctionRecommendations()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.wrap(item)
      )
      .provideEnvironment(r)
    def getLambdaFunctionRecommendationsPaginated(
        request: GetLambdaFunctionRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest,
      GetLambdaFunctionRecommendationsResponse
    ]("getLambdaFunctionRecommendations", api.getLambdaFunctionRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def exportEBSVolumeRecommendations(
        request: ExportEbsVolumeRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest,
      ExportEbsVolumeRecommendationsResponse
    ]("exportEBSVolumeRecommendations", api.exportEBSVolumeRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def exportAutoScalingGroupRecommendations(
        request: ExportAutoScalingGroupRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest,
      ExportAutoScalingGroupRecommendationsResponse
    ](
      "exportAutoScalingGroupRecommendations",
      api.exportAutoScalingGroupRecommendations
    )(request.buildAwsValue())
      .map(
        zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.wrap
      )
      .provideEnvironment(r)
    def getLicenseRecommendations(
        request: GetLicenseRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsRequest,
      GetLicenseRecommendationsResponse
    ]("getLicenseRecommendations", api.getLicenseRecommendations)(
      request.buildAwsValue()
    ).map(zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse.wrap)
      .provideEnvironment(r)
    def exportLicenseRecommendations(
        request: ExportLicenseRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.ExportLicenseRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.ExportLicenseRecommendationsRequest,
      ExportLicenseRecommendationsResponse
    ]("exportLicenseRecommendations", api.exportLicenseRecommendations)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.ExportLicenseRecommendationsResponse.wrap
    ).provideEnvironment(r)
    def describeRecommendationExportJobs(
        request: DescribeRecommendationExportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest,
      RecommendationExportJob,
      DescribeRecommendationExportJobsPublisher
    ](
      "describeRecommendationExportJobs",
      api.describeRecommendationExportJobsPaginator,
      _.recommendationExportJobs()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.computeoptimizer.model.RecommendationExportJob.wrap(item)
      )
      .provideEnvironment(r)
    def describeRecommendationExportJobsPaginated(
        request: DescribeRecommendationExportJobsRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest,
      DescribeRecommendationExportJobsResponse
    ]("describeRecommendationExportJobs", api.describeRecommendationExportJobs)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.wrap
    ).provideEnvironment(r)
    def getRecommendationPreferences(
        request: GetRecommendationPreferencesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest,
      RecommendationPreferencesDetail,
      GetRecommendationPreferencesPublisher
    ](
      "getRecommendationPreferences",
      api.getRecommendationPreferencesPaginator,
      _.recommendationPreferencesDetails()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.computeoptimizer.model.RecommendationPreferencesDetail
          .wrap(item)
      )
      .provideEnvironment(r)
    def getRecommendationPreferencesPaginated(
        request: GetRecommendationPreferencesRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest,
      GetRecommendationPreferencesResponse
    ]("getRecommendationPreferences", api.getRecommendationPreferences)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.wrap
    ).provideEnvironment(r)
    def getRecommendationSummaries(
        request: GetRecommendationSummariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest,
      RecommendationSummary,
      GetRecommendationSummariesPublisher
    ](
      "getRecommendationSummaries",
      api.getRecommendationSummariesPaginator,
      _.recommendationSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.computeoptimizer.model.RecommendationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def getRecommendationSummariesPaginated(
        request: GetRecommendationSummariesRequest
    ): IO[
      AwsError,
      zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest,
      GetRecommendationSummariesResponse
    ]("getRecommendationSummaries", api.getRecommendationSummaries)(
      request.buildAwsValue()
    ).map(
      zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.wrap
    ).provideEnvironment(r)
  }
  def getEBSVolumeRecommendations(
      request: GetEbsVolumeRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEBSVolumeRecommendations(request))
  def getECSServiceRecommendationProjectedMetrics(
      request: GetEcsServiceRecommendationProjectedMetricsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getECSServiceRecommendationProjectedMetrics(request))
  def getEC2RecommendationProjectedMetrics(
      request: GetEc2RecommendationProjectedMetricsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEC2RecommendationProjectedMetrics(request))
  def exportLambdaFunctionRecommendations(
      request: ExportLambdaFunctionRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportLambdaFunctionRecommendations(request))
  def deleteRecommendationPreferences(
      request: DeleteRecommendationPreferencesRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRecommendationPreferences(request))
  def exportECSServiceRecommendations(
      request: ExportEcsServiceRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.ExportEcsServiceRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportECSServiceRecommendations(request))
  def exportEC2InstanceRecommendations(
      request: ExportEc2InstanceRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportEC2InstanceRecommendations(request))
  def getEnrollmentStatusesForOrganization(
      request: GetEnrollmentStatusesForOrganizationRequest
  ): ZStream[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.getEnrollmentStatusesForOrganization(request))
  def getEnrollmentStatusesForOrganizationPaginated(
      request: GetEnrollmentStatusesForOrganizationRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.getEnrollmentStatusesForOrganizationPaginated(request))
  def putRecommendationPreferences(
      request: PutRecommendationPreferencesRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRecommendationPreferences(request))
  def getECSServiceRecommendations(
      request: GetEcsServiceRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getECSServiceRecommendations(request))
  def getEffectiveRecommendationPreferences(
      request: GetEffectiveRecommendationPreferencesRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEffectiveRecommendationPreferences(request))
  def getEnrollmentStatus(request: GetEnrollmentStatusRequest): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnrollmentStatus(request))
  def getEC2InstanceRecommendations(
      request: GetEc2InstanceRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEC2InstanceRecommendations(request))
  def getAutoScalingGroupRecommendations(
      request: GetAutoScalingGroupRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAutoScalingGroupRecommendations(request))
  def updateEnrollmentStatus(request: UpdateEnrollmentStatusRequest): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnrollmentStatus(request))
  def getLambdaFunctionRecommendations(
      request: GetLambdaFunctionRecommendationsRequest
  ): ZStream[zio.aws.computeoptimizer.ComputeOptimizer, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.getLambdaFunctionRecommendations(request))
  def getLambdaFunctionRecommendationsPaginated(
      request: GetLambdaFunctionRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLambdaFunctionRecommendationsPaginated(request))
  def exportEBSVolumeRecommendations(
      request: ExportEbsVolumeRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportEBSVolumeRecommendations(request))
  def exportAutoScalingGroupRecommendations(
      request: ExportAutoScalingGroupRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportAutoScalingGroupRecommendations(request))
  def getLicenseRecommendations(request: GetLicenseRecommendationsRequest): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetLicenseRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLicenseRecommendations(request))
  def exportLicenseRecommendations(
      request: ExportLicenseRecommendationsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.ExportLicenseRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportLicenseRecommendations(request))
  def describeRecommendationExportJobs(
      request: DescribeRecommendationExportJobsRequest
  ): ZStream[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRecommendationExportJobs(request))
  def describeRecommendationExportJobsPaginated(
      request: DescribeRecommendationExportJobsRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecommendationExportJobsPaginated(request))
  def getRecommendationPreferences(
      request: GetRecommendationPreferencesRequest
  ): ZStream[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.getRecommendationPreferences(request))
  def getRecommendationPreferencesPaginated(
      request: GetRecommendationPreferencesRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecommendationPreferencesPaginated(request))
  def getRecommendationSummaries(
      request: GetRecommendationSummariesRequest
  ): ZStream[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getRecommendationSummaries(request))
  def getRecommendationSummariesPaginated(
      request: GetRecommendationSummariesRequest
  ): ZIO[
    zio.aws.computeoptimizer.ComputeOptimizer,
    AwsError,
    zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecommendationSummariesPaginated(request))
}
