package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  InstanceArn,
  AccountId,
  LastRefreshTimestamp,
  LookBackPeriodInDays,
  InstanceName,
  CurrentInstanceType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class InstanceRecommendation(
    instanceArn: Optional[InstanceArn] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    instanceName: Optional[InstanceName] = Optional.Absent,
    currentInstanceType: Optional[CurrentInstanceType] = Optional.Absent,
    finding: Optional[zio.aws.computeoptimizer.model.Finding] = Optional.Absent,
    findingReasonCodes: Optional[Iterable[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]] = Optional.Absent,
    utilizationMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = Optional.Absent,
    lookBackPeriodInDays: Optional[LookBackPeriodInDays] = Optional.Absent,
    recommendationOptions: Optional[
      Iterable[zio.aws.computeoptimizer.model.InstanceRecommendationOption]
    ] = Optional.Absent,
    recommendationSources: Optional[
      Iterable[zio.aws.computeoptimizer.model.RecommendationSource]
    ] = Optional.Absent,
    lastRefreshTimestamp: Optional[LastRefreshTimestamp] = Optional.Absent,
    currentPerformanceRisk: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = Optional.Absent,
    effectiveRecommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
    ] = Optional.Absent,
    inferredWorkloadTypes: Optional[
      Iterable[zio.aws.computeoptimizer.model.InferredWorkloadType]
    ] = Optional.Absent,
    instanceState: Optional[zio.aws.computeoptimizer.model.InstanceState] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.computeoptimizer.model.Tag]] =
      Optional.Absent,
    externalMetricStatus: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation = {
    import InstanceRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
      .builder()
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        instanceName.map(value => InstanceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(
        currentInstanceType.map(value =>
          CurrentInstanceType.unwrap(value): java.lang.String
        )
      )(_.currentInstanceType)
      .optionallyWith(finding.map(value => value.unwrap))(_.finding)
      .optionallyWith(
        findingReasonCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingReasonCodesWithStrings)
      .optionallyWith(
        utilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.utilizationMetrics)
      .optionallyWith(
        lookBackPeriodInDays.map(value =>
          LookBackPeriodInDays.unwrap(value): java.lang.Double
        )
      )(_.lookBackPeriodInDays)
      .optionallyWith(
        recommendationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationOptions)
      .optionallyWith(
        recommendationSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationSources)
      .optionallyWith(
        lastRefreshTimestamp.map(value =>
          LastRefreshTimestamp.unwrap(value): Instant
        )
      )(_.lastRefreshTimestamp)
      .optionallyWith(currentPerformanceRisk.map(value => value.unwrap))(
        _.currentPerformanceRisk
      )
      .optionallyWith(
        effectiveRecommendationPreferences.map(value => value.buildAwsValue())
      )(_.effectiveRecommendationPreferences)
      .optionallyWith(
        inferredWorkloadTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inferredWorkloadTypesWithStrings)
      .optionallyWith(instanceState.map(value => value.unwrap))(_.instanceState)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(externalMetricStatus.map(value => value.buildAwsValue()))(
        _.externalMetricStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly =
    zio.aws.computeoptimizer.model.InstanceRecommendation.wrap(buildAwsValue())
}
object InstanceRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.InstanceRecommendation =
      zio.aws.computeoptimizer.model.InstanceRecommendation(
        instanceArn.map(value => value),
        accountId.map(value => value),
        instanceName.map(value => value),
        currentInstanceType.map(value => value),
        finding.map(value => value),
        findingReasonCodes.map(value => value),
        utilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lookBackPeriodInDays.map(value => value),
        recommendationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRefreshTimestamp.map(value => value),
        currentPerformanceRisk.map(value => value),
        effectiveRecommendationPreferences.map(value => value.asEditable),
        inferredWorkloadTypes.map(value => value),
        instanceState.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        externalMetricStatus.map(value => value.asEditable)
      )
    def instanceArn: Optional[InstanceArn]
    def accountId: Optional[AccountId]
    def instanceName: Optional[InstanceName]
    def currentInstanceType: Optional[CurrentInstanceType]
    def finding: Optional[zio.aws.computeoptimizer.model.Finding]
    def findingReasonCodes: Optional[List[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]]
    def utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def lookBackPeriodInDays: Optional[LookBackPeriodInDays]
    def recommendationOptions: Optional[
      List[zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly]
    ]
    def recommendationSources: Optional[
      List[zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly]
    ]
    def lastRefreshTimestamp: Optional[LastRefreshTimestamp]
    def currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk]
    def effectiveRecommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ]
    def inferredWorkloadTypes
        : Optional[List[zio.aws.computeoptimizer.model.InferredWorkloadType]]
    def instanceState: Optional[zio.aws.computeoptimizer.model.InstanceState]
    def tags: Optional[List[zio.aws.computeoptimizer.model.Tag.ReadOnly]]
    def externalMetricStatus
        : Optional[zio.aws.computeoptimizer.model.ExternalMetricStatus.ReadOnly]
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInstanceName: ZIO[Any, AwsError, InstanceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getCurrentInstanceType: ZIO[Any, AwsError, CurrentInstanceType] =
      AwsError.unwrapOptionField("currentInstanceType", currentInstanceType)
    def getFinding: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Finding] =
      AwsError.unwrapOptionField("finding", finding)
    def getFindingReasonCodes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]] = AwsError.unwrapOptionField("findingReasonCodes", findingReasonCodes)
    def getUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("utilizationMetrics", utilizationMetrics)
    def getLookBackPeriodInDays: ZIO[Any, AwsError, LookBackPeriodInDays] =
      AwsError.unwrapOptionField("lookBackPeriodInDays", lookBackPeriodInDays)
    def getRecommendationOptions: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("recommendationOptions", recommendationOptions)
    def getRecommendationSources: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("recommendationSources", recommendationSources)
    def getLastRefreshTimestamp: ZIO[Any, AwsError, LastRefreshTimestamp] =
      AwsError.unwrapOptionField("lastRefreshTimestamp", lastRefreshTimestamp)
    def getCurrentPerformanceRisk: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRisk
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRisk",
      currentPerformanceRisk
    )
    def getEffectiveRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "effectiveRecommendationPreferences",
      effectiveRecommendationPreferences
    )
    def getInferredWorkloadTypes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InferredWorkloadType
    ]] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
    def getInstanceState
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.InstanceState] =
      AwsError.unwrapOptionField("instanceState", instanceState)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getExternalMetricStatus: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ExternalMetricStatus.ReadOnly
    ] = AwsError.unwrapOptionField("externalMetricStatus", externalMetricStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
  ) extends zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly {
    override val instanceArn: Optional[InstanceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceArn())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceArn(value)
      )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val instanceName: Optional[InstanceName] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceName())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.InstanceName(value)
      )
    override val currentInstanceType: Optional[CurrentInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInstanceType())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.CurrentInstanceType(value)
        )
    override val finding: Optional[zio.aws.computeoptimizer.model.Finding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finding())
        .map(value => zio.aws.computeoptimizer.model.Finding.wrap(value))
    override val findingReasonCodes: Optional[List[
      zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.findingReasonCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode
            .wrap(item)
        }.toList
      )
    override val utilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.utilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val lookBackPeriodInDays: Optional[LookBackPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lookBackPeriodInDays())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays(value)
        )
    override val recommendationOptions: Optional[
      List[zio.aws.computeoptimizer.model.InstanceRecommendationOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.InstanceRecommendationOption.wrap(item)
        }.toList
      )
    override val recommendationSources: Optional[
      List[zio.aws.computeoptimizer.model.RecommendationSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.RecommendationSource.wrap(item)
        }.toList
      )
    override val lastRefreshTimestamp: Optional[LastRefreshTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRefreshTimestamp())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp(value)
        )
    override val currentPerformanceRisk
        : Optional[zio.aws.computeoptimizer.model.CurrentPerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPerformanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.CurrentPerformanceRisk.wrap(value)
        )
    override val effectiveRecommendationPreferences: Optional[
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveRecommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
          .wrap(value)
      )
    override val inferredWorkloadTypes
        : Optional[List[zio.aws.computeoptimizer.model.InferredWorkloadType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferredWorkloadTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.InferredWorkloadType.wrap(item)
          }.toList
        )
    override val instanceState
        : Optional[zio.aws.computeoptimizer.model.InstanceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceState())
        .map(value => zio.aws.computeoptimizer.model.InstanceState.wrap(value))
    override val tags
        : Optional[List[zio.aws.computeoptimizer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.Tag.wrap(item)
          }.toList
        )
    override val externalMetricStatus: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.externalMetricStatus())
      .map(value =>
        zio.aws.computeoptimizer.model.ExternalMetricStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendation
  ): zio.aws.computeoptimizer.model.InstanceRecommendation.ReadOnly =
    new Wrapper(impl)
}
