package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InferredWorkloadSaving(
    inferredWorkloadTypes: Optional[
      Iterable[zio.aws.computeoptimizer.model.InferredWorkloadType]
    ] = Optional.Absent,
    estimatedMonthlySavings: Optional[
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving = {
    import InferredWorkloadSaving.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving
      .builder()
      .optionallyWith(
        inferredWorkloadTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inferredWorkloadTypesWithStrings)
      .optionallyWith(
        estimatedMonthlySavings.map(value => value.buildAwsValue())
      )(_.estimatedMonthlySavings)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.InferredWorkloadSaving.ReadOnly =
    zio.aws.computeoptimizer.model.InferredWorkloadSaving.wrap(buildAwsValue())
}
object InferredWorkloadSaving {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.InferredWorkloadSaving =
      zio.aws.computeoptimizer.model.InferredWorkloadSaving(
        inferredWorkloadTypes.map(value => value),
        estimatedMonthlySavings.map(value => value.asEditable)
      )
    def inferredWorkloadTypes
        : Optional[List[zio.aws.computeoptimizer.model.InferredWorkloadType]]
    def estimatedMonthlySavings: Optional[
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly
    ]
    def getInferredWorkloadTypes: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InferredWorkloadType
    ]] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
    def getEstimatedMonthlySavings: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "estimatedMonthlySavings",
      estimatedMonthlySavings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving
  ) extends zio.aws.computeoptimizer.model.InferredWorkloadSaving.ReadOnly {
    override val inferredWorkloadTypes
        : Optional[List[zio.aws.computeoptimizer.model.InferredWorkloadType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferredWorkloadTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.InferredWorkloadType.wrap(item)
          }.toList
        )
    override val estimatedMonthlySavings: Optional[
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.estimatedMonthlySavings())
      .map(value =>
        zio.aws.computeoptimizer.model.EstimatedMonthlySavings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving
  ): zio.aws.computeoptimizer.model.InferredWorkloadSaving.ReadOnly =
    new Wrapper(impl)
}
