package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.JobId
import scala.jdk.CollectionConverters.*
final case class ExportLambdaFunctionRecommendationsResponse(
    jobId: Optional[JobId] = Optional.Absent,
    s3Destination: Optional[zio.aws.computeoptimizer.model.S3Destination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse = {
    import ExportLambdaFunctionRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse
      .wrap(buildAwsValue())
}
object ExportLambdaFunctionRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse =
      zio.aws.computeoptimizer.model
        .ExportLambdaFunctionRecommendationsResponse(
          jobId.map(value => value),
          s3Destination.map(value => value.asEditable)
        )
    def jobId: Optional[JobId]
    def s3Destination
        : Optional[zio.aws.computeoptimizer.model.S3Destination.ReadOnly]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.S3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.computeoptimizer.model.primitives.JobId(value))
    override val s3Destination
        : Optional[zio.aws.computeoptimizer.model.S3Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Destination())
        .map(value => zio.aws.computeoptimizer.model.S3Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse
  ): zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
