package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait AutoScalingConfiguration {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration
}
object AutoScalingConfiguration {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration
  ): zio.aws.computeoptimizer.model.AutoScalingConfiguration = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration.TARGET_TRACKING_SCALING_CPU =>
      val r = TargetTrackingScalingCpu
      r
    case software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration.TARGET_TRACKING_SCALING_MEMORY =>
      val r = TargetTrackingScalingMemory
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.AutoScalingConfiguration {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration =
      software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration.UNKNOWN_TO_SDK_VERSION
  }
  case object TargetTrackingScalingCpu
      extends zio.aws.computeoptimizer.model.AutoScalingConfiguration {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration =
      software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration.TARGET_TRACKING_SCALING_CPU
  }
  case object TargetTrackingScalingMemory
      extends zio.aws.computeoptimizer.model.AutoScalingConfiguration {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration =
      software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration.TARGET_TRACKING_SCALING_MEMORY
  }
}
