package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters.*
sealed trait ECSServiceMetricStatistic {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic
}
object ECSServiceMetricStatistic {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic
  ): zio.aws.computeoptimizer.model.ECSServiceMetricStatistic = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic.AVERAGE =>
      val r = Average
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ECSServiceMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Maximum
      extends zio.aws.computeoptimizer.model.ECSServiceMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic.MAXIMUM
  }
  case object Average
      extends zio.aws.computeoptimizer.model.ECSServiceMetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricStatistic.AVERAGE
  }
}
