package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  VolumeBurstIOPS,
  RootVolume,
  VolumeSize,
  VolumeBaselineIOPS,
  VolumeBaselineThroughput,
  VolumeBurstThroughput,
  VolumeType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VolumeConfiguration(
    volumeType: Optional[VolumeType] = Optional.Absent,
    volumeSize: Optional[VolumeSize] = Optional.Absent,
    volumeBaselineIOPS: Optional[VolumeBaselineIOPS] = Optional.Absent,
    volumeBurstIOPS: Optional[VolumeBurstIOPS] = Optional.Absent,
    volumeBaselineThroughput: Optional[VolumeBaselineThroughput] =
      Optional.Absent,
    volumeBurstThroughput: Optional[VolumeBurstThroughput] = Optional.Absent,
    rootVolume: Optional[RootVolume] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration = {
    import VolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
      .builder()
      .optionallyWith(
        volumeType.map(value => VolumeType.unwrap(value): java.lang.String)
      )(_.volumeType)
      .optionallyWith(
        volumeSize.map(value => VolumeSize.unwrap(value): Integer)
      )(_.volumeSize)
      .optionallyWith(
        volumeBaselineIOPS.map(value =>
          VolumeBaselineIOPS.unwrap(value): Integer
        )
      )(_.volumeBaselineIOPS)
      .optionallyWith(
        volumeBurstIOPS.map(value => VolumeBurstIOPS.unwrap(value): Integer)
      )(_.volumeBurstIOPS)
      .optionallyWith(
        volumeBaselineThroughput.map(value =>
          VolumeBaselineThroughput.unwrap(value): Integer
        )
      )(_.volumeBaselineThroughput)
      .optionallyWith(
        volumeBurstThroughput.map(value =>
          VolumeBurstThroughput.unwrap(value): Integer
        )
      )(_.volumeBurstThroughput)
      .optionallyWith(
        rootVolume.map(value => RootVolume.unwrap(value): java.lang.Boolean)
      )(_.rootVolume)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly =
    zio.aws.computeoptimizer.model.VolumeConfiguration.wrap(buildAwsValue())
}
object VolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.VolumeConfiguration =
      zio.aws.computeoptimizer.model.VolumeConfiguration(
        volumeType.map(value => value),
        volumeSize.map(value => value),
        volumeBaselineIOPS.map(value => value),
        volumeBurstIOPS.map(value => value),
        volumeBaselineThroughput.map(value => value),
        volumeBurstThroughput.map(value => value),
        rootVolume.map(value => value)
      )
    def volumeType: Optional[VolumeType]
    def volumeSize: Optional[VolumeSize]
    def volumeBaselineIOPS: Optional[VolumeBaselineIOPS]
    def volumeBurstIOPS: Optional[VolumeBurstIOPS]
    def volumeBaselineThroughput: Optional[VolumeBaselineThroughput]
    def volumeBurstThroughput: Optional[VolumeBurstThroughput]
    def rootVolume: Optional[RootVolume]
    def getVolumeType: ZIO[Any, AwsError, VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeSize: ZIO[Any, AwsError, VolumeSize] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeBaselineIOPS: ZIO[Any, AwsError, VolumeBaselineIOPS] =
      AwsError.unwrapOptionField("volumeBaselineIOPS", volumeBaselineIOPS)
    def getVolumeBurstIOPS: ZIO[Any, AwsError, VolumeBurstIOPS] =
      AwsError.unwrapOptionField("volumeBurstIOPS", volumeBurstIOPS)
    def getVolumeBaselineThroughput
        : ZIO[Any, AwsError, VolumeBaselineThroughput] = AwsError
      .unwrapOptionField("volumeBaselineThroughput", volumeBaselineThroughput)
    def getVolumeBurstThroughput: ZIO[Any, AwsError, VolumeBurstThroughput] =
      AwsError.unwrapOptionField("volumeBurstThroughput", volumeBurstThroughput)
    def getRootVolume: ZIO[Any, AwsError, RootVolume] =
      AwsError.unwrapOptionField("rootVolume", rootVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
  ) extends zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly {
    override val volumeType: Optional[VolumeType] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeType())
      .map(value => zio.aws.computeoptimizer.model.primitives.VolumeType(value))
    override val volumeSize: Optional[VolumeSize] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => zio.aws.computeoptimizer.model.primitives.VolumeSize(value))
    override val volumeBaselineIOPS: Optional[VolumeBaselineIOPS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeBaselineIOPS())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.VolumeBaselineIOPS(value)
        )
    override val volumeBurstIOPS: Optional[VolumeBurstIOPS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeBurstIOPS())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.VolumeBurstIOPS(value)
        )
    override val volumeBaselineThroughput: Optional[VolumeBaselineThroughput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeBaselineThroughput())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives
            .VolumeBaselineThroughput(value)
        )
    override val volumeBurstThroughput: Optional[VolumeBurstThroughput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeBurstThroughput())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.VolumeBurstThroughput(value)
        )
    override val rootVolume: Optional[RootVolume] = zio.aws.core.internal
      .optionalFromNullable(impl.rootVolume())
      .map(value => zio.aws.computeoptimizer.model.primitives.RootVolume(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.VolumeConfiguration
  ): zio.aws.computeoptimizer.model.VolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
