package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetEcsServiceRecommendationProjectedMetricsResponse(
    recommendedOptionProjectedMetrics: Optional[Iterable[
      zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse = {
    import GetEcsServiceRecommendationProjectedMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse
      .builder()
      .optionallyWith(
        recommendedOptionProjectedMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendedOptionProjectedMetrics)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse
      .wrap(buildAwsValue())
}
object GetEcsServiceRecommendationProjectedMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse =
      zio.aws.computeoptimizer.model
        .GetEcsServiceRecommendationProjectedMetricsResponse(
          recommendedOptionProjectedMetrics.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def recommendedOptionProjectedMetrics: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric.ReadOnly
    ]]
    def getRecommendedOptionProjectedMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendedOptionProjectedMetrics",
      recommendedOptionProjectedMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse
  ) extends zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly {
    override val recommendedOptionProjectedMetrics: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendedOptionProjectedMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse
  ): zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
