package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExternalMetricsPreference(
    source: Optional[zio.aws.computeoptimizer.model.ExternalMetricsSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference = {
    import ExternalMetricsPreference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference
      .builder()
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly =
    zio.aws.computeoptimizer.model.ExternalMetricsPreference
      .wrap(buildAwsValue())
}
object ExternalMetricsPreference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ExternalMetricsPreference =
      zio.aws.computeoptimizer.model
        .ExternalMetricsPreference(source.map(value => value))
    def source: Optional[zio.aws.computeoptimizer.model.ExternalMetricsSource]
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ExternalMetricsSource
    ] = AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference
  ) extends zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly {
    override val source
        : Optional[zio.aws.computeoptimizer.model.ExternalMetricsSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value =>
          zio.aws.computeoptimizer.model.ExternalMetricsSource.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference
  ): zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly =
    new Wrapper(impl)
}
